/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.VoteValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VoteSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VoteSummary> {
    private static final SdkField<String> VOTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Vote").getter(VoteSummary.getter(VoteSummary::voteAsString)).setter(VoteSummary.setter(Builder::vote)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vote").build()}).build();
    private static final SdkField<String> MEMBER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberName").getter(VoteSummary.getter(VoteSummary::memberName)).setter(VoteSummary.setter(Builder::memberName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberName").build()}).build();
    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberId").getter(VoteSummary.getter(VoteSummary::memberId)).setter(VoteSummary.setter(Builder::memberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOTE_FIELD, MEMBER_NAME_FIELD, MEMBER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VoteSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String vote;
    private final String memberName;
    private final String memberId;

    private VoteSummary(BuilderImpl builder) {
        this.vote = builder.vote;
        this.memberName = builder.memberName;
        this.memberId = builder.memberId;
    }

    public final VoteValue vote() {
        return VoteValue.fromValue(this.vote);
    }

    public final String voteAsString() {
        return this.vote;
    }

    public final String memberName() {
        return this.memberName;
    }

    public final String memberId() {
        return this.memberId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.voteAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberName());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoteSummary)) {
            return false;
        }
        VoteSummary other = (VoteSummary)obj;
        return Objects.equals(this.voteAsString(), other.voteAsString()) && Objects.equals(this.memberName(), other.memberName()) && Objects.equals(this.memberId(), other.memberId());
    }

    public final String toString() {
        return ToString.builder((String)"VoteSummary").add("Vote", (Object)this.voteAsString()).add("MemberName", (Object)this.memberName()).add("MemberId", (Object)this.memberId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Vote": {
                return Optional.ofNullable(clazz.cast(this.voteAsString()));
            }
            case "MemberName": {
                return Optional.ofNullable(clazz.cast(this.memberName()));
            }
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Vote", VOTE_FIELD);
        map.put("MemberName", MEMBER_NAME_FIELD);
        map.put("MemberId", MEMBER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VoteSummary, T> g) {
        return obj -> g.apply((VoteSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vote;
        private String memberName;
        private String memberId;

        private BuilderImpl() {
        }

        private BuilderImpl(VoteSummary model) {
            this.vote(model.vote);
            this.memberName(model.memberName);
            this.memberId(model.memberId);
        }

        public final String getVote() {
            return this.vote;
        }

        public final void setVote(String vote) {
            this.vote = vote;
        }

        @Override
        public final Builder vote(String vote) {
            this.vote = vote;
            return this;
        }

        @Override
        public final Builder vote(VoteValue vote) {
            this.vote(vote == null ? null : vote.toString());
            return this;
        }

        public final String getMemberName() {
            return this.memberName;
        }

        public final void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        @Override
        public final Builder memberName(String memberName) {
            this.memberName = memberName;
            return this;
        }

        public final String getMemberId() {
            return this.memberId;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public VoteSummary build() {
            return new VoteSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VoteSummary> {
        public Builder vote(String var1);

        public Builder vote(VoteValue var1);

        public Builder memberName(String var1);

        public Builder memberId(String var1);
    }
}

