/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.NodeLogPublishingConfiguration;
import software.amazon.awssdk.services.managedblockchain.model.StateDBType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeConfiguration> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(NodeConfiguration.getter(NodeConfiguration::instanceType)).setter(NodeConfiguration.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(NodeConfiguration.getter(NodeConfiguration::availabilityZone)).setter(NodeConfiguration.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<NodeLogPublishingConfiguration> LOG_PUBLISHING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPublishingConfiguration").getter(NodeConfiguration.getter(NodeConfiguration::logPublishingConfiguration)).setter(NodeConfiguration.setter(Builder::logPublishingConfiguration)).constructor(NodeLogPublishingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingConfiguration").build()}).build();
    private static final SdkField<String> STATE_DB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateDB").getter(NodeConfiguration.getter(NodeConfiguration::stateDBAsString)).setter(NodeConfiguration.setter(Builder::stateDB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateDB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, LOG_PUBLISHING_CONFIGURATION_FIELD, STATE_DB_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final String availabilityZone;
    private final NodeLogPublishingConfiguration logPublishingConfiguration;
    private final String stateDB;

    private NodeConfiguration(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.availabilityZone = builder.availabilityZone;
        this.logPublishingConfiguration = builder.logPublishingConfiguration;
        this.stateDB = builder.stateDB;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final NodeLogPublishingConfiguration logPublishingConfiguration() {
        return this.logPublishingConfiguration;
    }

    public final StateDBType stateDB() {
        return StateDBType.fromValue(this.stateDB);
    }

    public final String stateDBAsString() {
        return this.stateDB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDBAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeConfiguration)) {
            return false;
        }
        NodeConfiguration other = (NodeConfiguration)obj;
        return Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.logPublishingConfiguration(), other.logPublishingConfiguration()) && Objects.equals(this.stateDBAsString(), other.stateDBAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NodeConfiguration").add("InstanceType", (Object)this.instanceType()).add("AvailabilityZone", (Object)this.availabilityZone()).add("LogPublishingConfiguration", (Object)this.logPublishingConfiguration()).add("StateDB", (Object)this.stateDBAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "LogPublishingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logPublishingConfiguration()));
            }
            case "StateDB": {
                return Optional.ofNullable(clazz.cast(this.stateDBAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeConfiguration, T> g) {
        return obj -> g.apply((NodeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private String availabilityZone;
        private NodeLogPublishingConfiguration logPublishingConfiguration;
        private String stateDB;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeConfiguration model) {
            this.instanceType(model.instanceType);
            this.availabilityZone(model.availabilityZone);
            this.logPublishingConfiguration(model.logPublishingConfiguration);
            this.stateDB(model.stateDB);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final NodeLogPublishingConfiguration.Builder getLogPublishingConfiguration() {
            return this.logPublishingConfiguration != null ? this.logPublishingConfiguration.toBuilder() : null;
        }

        public final void setLogPublishingConfiguration(NodeLogPublishingConfiguration.BuilderImpl logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration != null ? logPublishingConfiguration.build() : null;
        }

        @Override
        public final Builder logPublishingConfiguration(NodeLogPublishingConfiguration logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration;
            return this;
        }

        public final String getStateDB() {
            return this.stateDB;
        }

        public final void setStateDB(String stateDB) {
            this.stateDB = stateDB;
        }

        @Override
        public final Builder stateDB(String stateDB) {
            this.stateDB = stateDB;
            return this;
        }

        @Override
        public final Builder stateDB(StateDBType stateDB) {
            this.stateDB(stateDB == null ? null : stateDB.toString());
            return this;
        }

        public NodeConfiguration build() {
            return new NodeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeConfiguration> {
        public Builder instanceType(String var1);

        public Builder availabilityZone(String var1);

        public Builder logPublishingConfiguration(NodeLogPublishingConfiguration var1);

        default public Builder logPublishingConfiguration(Consumer<NodeLogPublishingConfiguration.Builder> logPublishingConfiguration) {
            return this.logPublishingConfiguration((NodeLogPublishingConfiguration)((NodeLogPublishingConfiguration.Builder)NodeLogPublishingConfiguration.builder().applyMutation(logPublishingConfiguration)).build());
        }

        public Builder stateDB(String var1);

        public Builder stateDB(StateDBType var1);
    }
}

