/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.managedblockchain.model.InputTagMapCopier;
import software.amazon.awssdk.services.managedblockchain.model.MemberFrameworkConfiguration;
import software.amazon.awssdk.services.managedblockchain.model.MemberLogPublishingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemberConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemberConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(MemberConfiguration.getter(MemberConfiguration::name)).setter(MemberConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(MemberConfiguration.getter(MemberConfiguration::description)).setter(MemberConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<MemberFrameworkConfiguration> FRAMEWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameworkConfiguration").getter(MemberConfiguration.getter(MemberConfiguration::frameworkConfiguration)).setter(MemberConfiguration.setter(Builder::frameworkConfiguration)).constructor(MemberFrameworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkConfiguration").build()}).build();
    private static final SdkField<MemberLogPublishingConfiguration> LOG_PUBLISHING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPublishingConfiguration").getter(MemberConfiguration.getter(MemberConfiguration::logPublishingConfiguration)).setter(MemberConfiguration.setter(Builder::logPublishingConfiguration)).constructor(MemberLogPublishingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(MemberConfiguration.getter(MemberConfiguration::tags)).setter(MemberConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(MemberConfiguration.getter(MemberConfiguration::kmsKeyArn)).setter(MemberConfiguration.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, FRAMEWORK_CONFIGURATION_FIELD, LOG_PUBLISHING_CONFIGURATION_FIELD, TAGS_FIELD, KMS_KEY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final MemberFrameworkConfiguration frameworkConfiguration;
    private final MemberLogPublishingConfiguration logPublishingConfiguration;
    private final Map<String, String> tags;
    private final String kmsKeyArn;

    private MemberConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.frameworkConfiguration = builder.frameworkConfiguration;
        this.logPublishingConfiguration = builder.logPublishingConfiguration;
        this.tags = builder.tags;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final MemberFrameworkConfiguration frameworkConfiguration() {
        return this.frameworkConfiguration;
    }

    public final MemberLogPublishingConfiguration logPublishingConfiguration() {
        return this.logPublishingConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberConfiguration)) {
            return false;
        }
        MemberConfiguration other = (MemberConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.frameworkConfiguration(), other.frameworkConfiguration()) && Objects.equals(this.logPublishingConfiguration(), other.logPublishingConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"MemberConfiguration").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("FrameworkConfiguration", (Object)this.frameworkConfiguration()).add("LogPublishingConfiguration", (Object)this.logPublishingConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "FrameworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.frameworkConfiguration()));
            }
            case "LogPublishingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logPublishingConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberConfiguration, T> g) {
        return obj -> g.apply((MemberConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private MemberFrameworkConfiguration frameworkConfiguration;
        private MemberLogPublishingConfiguration logPublishingConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberConfiguration model) {
            this.name(model.name);
            this.description(model.description);
            this.frameworkConfiguration(model.frameworkConfiguration);
            this.logPublishingConfiguration(model.logPublishingConfiguration);
            this.tags(model.tags);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final MemberFrameworkConfiguration.Builder getFrameworkConfiguration() {
            return this.frameworkConfiguration != null ? this.frameworkConfiguration.toBuilder() : null;
        }

        public final void setFrameworkConfiguration(MemberFrameworkConfiguration.BuilderImpl frameworkConfiguration) {
            this.frameworkConfiguration = frameworkConfiguration != null ? frameworkConfiguration.build() : null;
        }

        @Override
        public final Builder frameworkConfiguration(MemberFrameworkConfiguration frameworkConfiguration) {
            this.frameworkConfiguration = frameworkConfiguration;
            return this;
        }

        public final MemberLogPublishingConfiguration.Builder getLogPublishingConfiguration() {
            return this.logPublishingConfiguration != null ? this.logPublishingConfiguration.toBuilder() : null;
        }

        public final void setLogPublishingConfiguration(MemberLogPublishingConfiguration.BuilderImpl logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration != null ? logPublishingConfiguration.build() : null;
        }

        @Override
        public final Builder logPublishingConfiguration(MemberLogPublishingConfiguration logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = InputTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = InputTagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public MemberConfiguration build() {
            return new MemberConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemberConfiguration> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder frameworkConfiguration(MemberFrameworkConfiguration var1);

        default public Builder frameworkConfiguration(Consumer<MemberFrameworkConfiguration.Builder> frameworkConfiguration) {
            return this.frameworkConfiguration((MemberFrameworkConfiguration)((MemberFrameworkConfiguration.Builder)MemberFrameworkConfiguration.builder().applyMutation(frameworkConfiguration)).build());
        }

        public Builder logPublishingConfiguration(MemberLogPublishingConfiguration var1);

        default public Builder logPublishingConfiguration(Consumer<MemberLogPublishingConfiguration.Builder> logPublishingConfiguration) {
            return this.logPublishingConfiguration((MemberLogPublishingConfiguration)((MemberLogPublishingConfiguration.Builder)MemberLogPublishingConfiguration.builder().applyMutation(logPublishingConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder kmsKeyArn(String var1);
    }
}

