/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.NodeEthereumAttributes;
import software.amazon.awssdk.services.managedblockchain.model.NodeFabricAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeFrameworkAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeFrameworkAttributes> {
    private static final SdkField<NodeFabricAttributes> FABRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Fabric").getter(NodeFrameworkAttributes.getter(NodeFrameworkAttributes::fabric)).setter(NodeFrameworkAttributes.setter(Builder::fabric)).constructor(NodeFabricAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fabric").build()}).build();
    private static final SdkField<NodeEthereumAttributes> ETHEREUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ethereum").getter(NodeFrameworkAttributes.getter(NodeFrameworkAttributes::ethereum)).setter(NodeFrameworkAttributes.setter(Builder::ethereum)).constructor(NodeEthereumAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ethereum").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FABRIC_FIELD, ETHEREUM_FIELD));
    private static final long serialVersionUID = 1L;
    private final NodeFabricAttributes fabric;
    private final NodeEthereumAttributes ethereum;

    private NodeFrameworkAttributes(BuilderImpl builder) {
        this.fabric = builder.fabric;
        this.ethereum = builder.ethereum;
    }

    public final NodeFabricAttributes fabric() {
        return this.fabric;
    }

    public final NodeEthereumAttributes ethereum() {
        return this.ethereum;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fabric());
        hashCode = 31 * hashCode + Objects.hashCode(this.ethereum());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeFrameworkAttributes)) {
            return false;
        }
        NodeFrameworkAttributes other = (NodeFrameworkAttributes)obj;
        return Objects.equals(this.fabric(), other.fabric()) && Objects.equals(this.ethereum(), other.ethereum());
    }

    public final String toString() {
        return ToString.builder((String)"NodeFrameworkAttributes").add("Fabric", (Object)this.fabric()).add("Ethereum", (Object)this.ethereum()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fabric": {
                return Optional.ofNullable(clazz.cast(this.fabric()));
            }
            case "Ethereum": {
                return Optional.ofNullable(clazz.cast(this.ethereum()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeFrameworkAttributes, T> g) {
        return obj -> g.apply((NodeFrameworkAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NodeFabricAttributes fabric;
        private NodeEthereumAttributes ethereum;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeFrameworkAttributes model) {
            this.fabric(model.fabric);
            this.ethereum(model.ethereum);
        }

        public final NodeFabricAttributes.Builder getFabric() {
            return this.fabric != null ? this.fabric.toBuilder() : null;
        }

        @Override
        public final Builder fabric(NodeFabricAttributes fabric) {
            this.fabric = fabric;
            return this;
        }

        public final void setFabric(NodeFabricAttributes.BuilderImpl fabric) {
            this.fabric = fabric != null ? fabric.build() : null;
        }

        public final NodeEthereumAttributes.Builder getEthereum() {
            return this.ethereum != null ? this.ethereum.toBuilder() : null;
        }

        @Override
        public final Builder ethereum(NodeEthereumAttributes ethereum) {
            this.ethereum = ethereum;
            return this;
        }

        public final void setEthereum(NodeEthereumAttributes.BuilderImpl ethereum) {
            this.ethereum = ethereum != null ? ethereum.build() : null;
        }

        public NodeFrameworkAttributes build() {
            return new NodeFrameworkAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeFrameworkAttributes> {
        public Builder fabric(NodeFabricAttributes var1);

        default public Builder fabric(Consumer<NodeFabricAttributes.Builder> fabric) {
            return this.fabric((NodeFabricAttributes)((NodeFabricAttributes.Builder)NodeFabricAttributes.builder().applyMutation(fabric)).build());
        }

        public Builder ethereum(NodeEthereumAttributes var1);

        default public Builder ethereum(Consumer<NodeEthereumAttributes.Builder> ethereum) {
            return this.ethereum((NodeEthereumAttributes)((NodeEthereumAttributes.Builder)NodeEthereumAttributes.builder().applyMutation(ethereum)).build());
        }
    }
}

