/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainResponse;
import software.amazon.awssdk.services.managedblockchain.model.MemberSummary;
import software.amazon.awssdk.services.managedblockchain.model.MemberSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMembersResponse
extends ManagedBlockchainResponse
implements ToCopyableBuilder<Builder, ListMembersResponse> {
    private static final SdkField<List<MemberSummary>> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Members").getter(ListMembersResponse.getter(ListMembersResponse::members)).setter(ListMembersResponse.setter(Builder::members)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMembersResponse.getter(ListMembersResponse::nextToken)).setter(ListMembersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MemberSummary> members;
    private final String nextToken;

    private ListMembersResponse(BuilderImpl builder) {
        super(builder);
        this.members = builder.members;
        this.nextToken = builder.nextToken;
    }

    public boolean hasMembers() {
        return this.members != null && !(this.members instanceof SdkAutoConstructList);
    }

    public List<MemberSummary> members() {
        return this.members;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembers() ? this.members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembersResponse)) {
            return false;
        }
        ListMembersResponse other = (ListMembersResponse)((Object)obj);
        return this.hasMembers() == other.hasMembers() && Objects.equals(this.members(), other.members()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListMembersResponse").add("Members", this.hasMembers() ? this.members() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMembersResponse, T> g) {
        return obj -> g.apply((ListMembersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainResponse.BuilderImpl
    implements Builder {
        private List<MemberSummary> members = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembersResponse model) {
            super(model);
            this.members(model.members);
            this.nextToken(model.nextToken);
        }

        public final Collection<MemberSummary.Builder> getMembers() {
            if (this.members instanceof SdkAutoConstructList) {
                return null;
            }
            return this.members != null ? (Collection)this.members.stream().map(MemberSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder members(Collection<MemberSummary> members) {
            this.members = MemberSummaryListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(MemberSummary ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<MemberSummary.Builder> ... members) {
            this.members(Stream.of(members).map(c -> (MemberSummary)((MemberSummary.Builder)MemberSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMembers(Collection<MemberSummary.BuilderImpl> members) {
            this.members = MemberSummaryListCopier.copyFromBuilder(members);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMembersResponse build() {
            return new ListMembersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ManagedBlockchainResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMembersResponse> {
        public Builder members(Collection<MemberSummary> var1);

        public Builder members(MemberSummary ... var1);

        public Builder members(Consumer<MemberSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

