/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngressPointConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngressPointConfiguration> {
    private static final SdkField<String> SMTP_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SmtpPassword").getter(IngressPointConfiguration.getter(IngressPointConfiguration::smtpPassword)).setter(IngressPointConfiguration.setter(Builder::smtpPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmtpPassword").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(IngressPointConfiguration.getter(IngressPointConfiguration::secretArn)).setter(IngressPointConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMTP_PASSWORD_FIELD, SECRET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IngressPointConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String smtpPassword;
    private final String secretArn;
    private final Type type;

    private IngressPointConfiguration(BuilderImpl builder) {
        this.smtpPassword = builder.smtpPassword;
        this.secretArn = builder.secretArn;
        this.type = builder.type;
    }

    public final String smtpPassword() {
        return this.smtpPassword;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.smtpPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressPointConfiguration)) {
            return false;
        }
        IngressPointConfiguration other = (IngressPointConfiguration)obj;
        return Objects.equals(this.smtpPassword(), other.smtpPassword()) && Objects.equals(this.secretArn(), other.secretArn());
    }

    public final String toString() {
        return ToString.builder((String)"IngressPointConfiguration").add("SmtpPassword", (Object)(this.smtpPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("SecretArn", (Object)this.secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SmtpPassword": {
                return Optional.ofNullable(clazz.cast(this.smtpPassword()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
        }
        return Optional.empty();
    }

    public static IngressPointConfiguration fromSmtpPassword(String smtpPassword) {
        return (IngressPointConfiguration)IngressPointConfiguration.builder().smtpPassword(smtpPassword).build();
    }

    public static IngressPointConfiguration fromSecretArn(String secretArn) {
        return (IngressPointConfiguration)IngressPointConfiguration.builder().secretArn(secretArn).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SmtpPassword", SMTP_PASSWORD_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressPointConfiguration, T> g) {
        return obj -> g.apply((IngressPointConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SMTP_PASSWORD,
        SECRET_ARN,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String smtpPassword;
        private String secretArn;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IngressPointConfiguration model) {
            this.smtpPassword(model.smtpPassword);
            this.secretArn(model.secretArn);
        }

        public final String getSmtpPassword() {
            return this.smtpPassword;
        }

        public final void setSmtpPassword(String smtpPassword) {
            String oldValue = this.smtpPassword;
            this.smtpPassword = smtpPassword;
            this.handleUnionValueChange(Type.SMTP_PASSWORD, oldValue, this.smtpPassword);
        }

        @Override
        public final Builder smtpPassword(String smtpPassword) {
            String oldValue = this.smtpPassword;
            this.smtpPassword = smtpPassword;
            this.handleUnionValueChange(Type.SMTP_PASSWORD, oldValue, this.smtpPassword);
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            String oldValue = this.secretArn;
            this.secretArn = secretArn;
            this.handleUnionValueChange(Type.SECRET_ARN, oldValue, this.secretArn);
        }

        @Override
        public final Builder secretArn(String secretArn) {
            String oldValue = this.secretArn;
            this.secretArn = secretArn;
            this.handleUnionValueChange(Type.SECRET_ARN, oldValue, this.secretArn);
            return this;
        }

        public IngressPointConfiguration build() {
            return new IngressPointConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngressPointConfiguration> {
        public Builder smtpPassword(String var1);

        public Builder secretArn(String var1);
    }
}

