/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.MailManagerRequest;
import software.amazon.awssdk.services.mailmanager.model.RelayAuthentication;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRelayRequest
extends MailManagerRequest
implements ToCopyableBuilder<Builder, UpdateRelayRequest> {
    private static final SdkField<RelayAuthentication> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Authentication").getter(UpdateRelayRequest.getter(UpdateRelayRequest::authentication)).setter(UpdateRelayRequest.setter(Builder::authentication)).constructor(RelayAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication").build()}).build();
    private static final SdkField<String> RELAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelayId").getter(UpdateRelayRequest.getter(UpdateRelayRequest::relayId)).setter(UpdateRelayRequest.setter(Builder::relayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayId").build()}).build();
    private static final SdkField<String> RELAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelayName").getter(UpdateRelayRequest.getter(UpdateRelayRequest::relayName)).setter(UpdateRelayRequest.setter(Builder::relayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayName").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(UpdateRelayRequest.getter(UpdateRelayRequest::serverName)).setter(UpdateRelayRequest.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> SERVER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ServerPort").getter(UpdateRelayRequest.getter(UpdateRelayRequest::serverPort)).setter(UpdateRelayRequest.setter(Builder::serverPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_FIELD, RELAY_ID_FIELD, RELAY_NAME_FIELD, SERVER_NAME_FIELD, SERVER_PORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRelayRequest.memberNameToFieldInitializer();
    private final RelayAuthentication authentication;
    private final String relayId;
    private final String relayName;
    private final String serverName;
    private final Integer serverPort;

    private UpdateRelayRequest(BuilderImpl builder) {
        super(builder);
        this.authentication = builder.authentication;
        this.relayId = builder.relayId;
        this.relayName = builder.relayName;
        this.serverName = builder.serverName;
        this.serverPort = builder.serverPort;
    }

    public final RelayAuthentication authentication() {
        return this.authentication;
    }

    public final String relayId() {
        return this.relayId;
    }

    public final String relayName() {
        return this.relayName;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final Integer serverPort() {
        return this.serverPort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.relayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverPort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRelayRequest)) {
            return false;
        }
        UpdateRelayRequest other = (UpdateRelayRequest)((Object)obj);
        return Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.relayId(), other.relayId()) && Objects.equals(this.relayName(), other.relayName()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.serverPort(), other.serverPort());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRelayRequest").add("Authentication", (Object)this.authentication()).add("RelayId", (Object)this.relayId()).add("RelayName", (Object)this.relayName()).add("ServerName", (Object)this.serverName()).add("ServerPort", (Object)this.serverPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "RelayId": {
                return Optional.ofNullable(clazz.cast(this.relayId()));
            }
            case "RelayName": {
                return Optional.ofNullable(clazz.cast(this.relayName()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "ServerPort": {
                return Optional.ofNullable(clazz.cast(this.serverPort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Authentication", AUTHENTICATION_FIELD);
        map.put("RelayId", RELAY_ID_FIELD);
        map.put("RelayName", RELAY_NAME_FIELD);
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("ServerPort", SERVER_PORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRelayRequest, T> g) {
        return obj -> g.apply((UpdateRelayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerRequest.BuilderImpl
    implements Builder {
        private RelayAuthentication authentication;
        private String relayId;
        private String relayName;
        private String serverName;
        private Integer serverPort;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRelayRequest model) {
            super(model);
            this.authentication(model.authentication);
            this.relayId(model.relayId);
            this.relayName(model.relayName);
            this.serverName(model.serverName);
            this.serverPort(model.serverPort);
        }

        public final RelayAuthentication.Builder getAuthentication() {
            return this.authentication != null ? this.authentication.toBuilder() : null;
        }

        public final void setAuthentication(RelayAuthentication.BuilderImpl authentication) {
            this.authentication = authentication != null ? authentication.build() : null;
        }

        @Override
        public final Builder authentication(RelayAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getRelayId() {
            return this.relayId;
        }

        public final void setRelayId(String relayId) {
            this.relayId = relayId;
        }

        @Override
        public final Builder relayId(String relayId) {
            this.relayId = relayId;
            return this;
        }

        public final String getRelayName() {
            return this.relayName;
        }

        public final void setRelayName(String relayName) {
            this.relayName = relayName;
        }

        @Override
        public final Builder relayName(String relayName) {
            this.relayName = relayName;
            return this;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getServerPort() {
            return this.serverPort;
        }

        public final void setServerPort(Integer serverPort) {
            this.serverPort = serverPort;
        }

        @Override
        public final Builder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRelayRequest build() {
            return new UpdateRelayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MailManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRelayRequest> {
        public Builder authentication(RelayAuthentication var1);

        default public Builder authentication(Consumer<RelayAuthentication.Builder> authentication) {
            return this.authentication((RelayAuthentication)((RelayAuthentication.Builder)RelayAuthentication.builder().applyMutation(authentication)).build());
        }

        public Builder relayId(String var1);

        public Builder relayName(String var1);

        public Builder serverName(String var1);

        public Builder serverPort(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

