/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.AcceptAction;
import software.amazon.awssdk.services.mailmanager.model.MailManagerRequest;
import software.amazon.awssdk.services.mailmanager.model.PolicyStatement;
import software.amazon.awssdk.services.mailmanager.model.PolicyStatementListCopier;
import software.amazon.awssdk.services.mailmanager.model.Tag;
import software.amazon.awssdk.services.mailmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrafficPolicyRequest
extends MailManagerRequest
implements ToCopyableBuilder<Builder, CreateTrafficPolicyRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateTrafficPolicyRequest.getter(CreateTrafficPolicyRequest::clientToken)).setter(CreateTrafficPolicyRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DEFAULT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultAction").getter(CreateTrafficPolicyRequest.getter(CreateTrafficPolicyRequest::defaultActionAsString)).setter(CreateTrafficPolicyRequest.setter(Builder::defaultAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()}).build();
    private static final SdkField<Integer> MAX_MESSAGE_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxMessageSizeBytes").getter(CreateTrafficPolicyRequest.getter(CreateTrafficPolicyRequest::maxMessageSizeBytes)).setter(CreateTrafficPolicyRequest.setter(Builder::maxMessageSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxMessageSizeBytes").build()}).build();
    private static final SdkField<List<PolicyStatement>> POLICY_STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyStatements").getter(CreateTrafficPolicyRequest.getter(CreateTrafficPolicyRequest::policyStatements)).setter(CreateTrafficPolicyRequest.setter(Builder::policyStatements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyStatements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateTrafficPolicyRequest.getter(CreateTrafficPolicyRequest::tags)).setter(CreateTrafficPolicyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyName").getter(CreateTrafficPolicyRequest.getter(CreateTrafficPolicyRequest::trafficPolicyName)).setter(CreateTrafficPolicyRequest.setter(Builder::trafficPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DEFAULT_ACTION_FIELD, MAX_MESSAGE_SIZE_BYTES_FIELD, POLICY_STATEMENTS_FIELD, TAGS_FIELD, TRAFFIC_POLICY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTrafficPolicyRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String defaultAction;
    private final Integer maxMessageSizeBytes;
    private final List<PolicyStatement> policyStatements;
    private final List<Tag> tags;
    private final String trafficPolicyName;

    private CreateTrafficPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.defaultAction = builder.defaultAction;
        this.maxMessageSizeBytes = builder.maxMessageSizeBytes;
        this.policyStatements = builder.policyStatements;
        this.tags = builder.tags;
        this.trafficPolicyName = builder.trafficPolicyName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final AcceptAction defaultAction() {
        return AcceptAction.fromValue(this.defaultAction);
    }

    public final String defaultActionAsString() {
        return this.defaultAction;
    }

    public final Integer maxMessageSizeBytes() {
        return this.maxMessageSizeBytes;
    }

    public final boolean hasPolicyStatements() {
        return this.policyStatements != null && !(this.policyStatements instanceof SdkAutoConstructList);
    }

    public final List<PolicyStatement> policyStatements() {
        return this.policyStatements;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String trafficPolicyName() {
        return this.trafficPolicyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxMessageSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyStatements() ? this.policyStatements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyRequest)) {
            return false;
        }
        CreateTrafficPolicyRequest other = (CreateTrafficPolicyRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.defaultActionAsString(), other.defaultActionAsString()) && Objects.equals(this.maxMessageSizeBytes(), other.maxMessageSizeBytes()) && this.hasPolicyStatements() == other.hasPolicyStatements() && Objects.equals(this.policyStatements(), other.policyStatements()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.trafficPolicyName(), other.trafficPolicyName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrafficPolicyRequest").add("ClientToken", (Object)this.clientToken()).add("DefaultAction", (Object)this.defaultActionAsString()).add("MaxMessageSizeBytes", (Object)this.maxMessageSizeBytes()).add("PolicyStatements", this.hasPolicyStatements() ? this.policyStatements() : null).add("Tags", this.hasTags() ? this.tags() : null).add("TrafficPolicyName", (Object)this.trafficPolicyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DefaultAction": {
                return Optional.ofNullable(clazz.cast(this.defaultActionAsString()));
            }
            case "MaxMessageSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.maxMessageSizeBytes()));
            }
            case "PolicyStatements": {
                return Optional.ofNullable(clazz.cast(this.policyStatements()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TrafficPolicyName": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DefaultAction", DEFAULT_ACTION_FIELD);
        map.put("MaxMessageSizeBytes", MAX_MESSAGE_SIZE_BYTES_FIELD);
        map.put("PolicyStatements", POLICY_STATEMENTS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TrafficPolicyName", TRAFFIC_POLICY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficPolicyRequest, T> g) {
        return obj -> g.apply((CreateTrafficPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String defaultAction;
        private Integer maxMessageSizeBytes;
        private List<PolicyStatement> policyStatements = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String trafficPolicyName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.defaultAction(model.defaultAction);
            this.maxMessageSizeBytes(model.maxMessageSizeBytes);
            this.policyStatements(model.policyStatements);
            this.tags(model.tags);
            this.trafficPolicyName(model.trafficPolicyName);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDefaultAction() {
            return this.defaultAction;
        }

        public final void setDefaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
        }

        @Override
        public final Builder defaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        @Override
        public final Builder defaultAction(AcceptAction defaultAction) {
            this.defaultAction(defaultAction == null ? null : defaultAction.toString());
            return this;
        }

        public final Integer getMaxMessageSizeBytes() {
            return this.maxMessageSizeBytes;
        }

        public final void setMaxMessageSizeBytes(Integer maxMessageSizeBytes) {
            this.maxMessageSizeBytes = maxMessageSizeBytes;
        }

        @Override
        public final Builder maxMessageSizeBytes(Integer maxMessageSizeBytes) {
            this.maxMessageSizeBytes = maxMessageSizeBytes;
            return this;
        }

        public final List<PolicyStatement.Builder> getPolicyStatements() {
            List<PolicyStatement.Builder> result = PolicyStatementListCopier.copyToBuilder(this.policyStatements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyStatements(Collection<PolicyStatement.BuilderImpl> policyStatements) {
            this.policyStatements = PolicyStatementListCopier.copyFromBuilder(policyStatements);
        }

        @Override
        public final Builder policyStatements(Collection<PolicyStatement> policyStatements) {
            this.policyStatements = PolicyStatementListCopier.copy(policyStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyStatements(PolicyStatement ... policyStatements) {
            this.policyStatements(Arrays.asList(policyStatements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyStatements(Consumer<PolicyStatement.Builder> ... policyStatements) {
            this.policyStatements(Stream.of(policyStatements).map(c -> (PolicyStatement)((PolicyStatement.Builder)PolicyStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTrafficPolicyName() {
            return this.trafficPolicyName;
        }

        public final void setTrafficPolicyName(String trafficPolicyName) {
            this.trafficPolicyName = trafficPolicyName;
        }

        @Override
        public final Builder trafficPolicyName(String trafficPolicyName) {
            this.trafficPolicyName = trafficPolicyName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrafficPolicyRequest build() {
            return new CreateTrafficPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MailManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrafficPolicyRequest> {
        public Builder clientToken(String var1);

        public Builder defaultAction(String var1);

        public Builder defaultAction(AcceptAction var1);

        public Builder maxMessageSizeBytes(Integer var1);

        public Builder policyStatements(Collection<PolicyStatement> var1);

        public Builder policyStatements(PolicyStatement ... var1);

        public Builder policyStatements(Consumer<PolicyStatement.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder trafficPolicyName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

