/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.IngressPointConfiguration;
import software.amazon.awssdk.services.mailmanager.model.IngressPointType;
import software.amazon.awssdk.services.mailmanager.model.MailManagerRequest;
import software.amazon.awssdk.services.mailmanager.model.NetworkConfiguration;
import software.amazon.awssdk.services.mailmanager.model.Tag;
import software.amazon.awssdk.services.mailmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIngressPointRequest
extends MailManagerRequest
implements ToCopyableBuilder<Builder, CreateIngressPointRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateIngressPointRequest.getter(CreateIngressPointRequest::clientToken)).setter(CreateIngressPointRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<IngressPointConfiguration> INGRESS_POINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngressPointConfiguration").getter(CreateIngressPointRequest.getter(CreateIngressPointRequest::ingressPointConfiguration)).setter(CreateIngressPointRequest.setter(Builder::ingressPointConfiguration)).constructor(IngressPointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointConfiguration").build()}).build();
    private static final SdkField<String> INGRESS_POINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngressPointName").getter(CreateIngressPointRequest.getter(CreateIngressPointRequest::ingressPointName)).setter(CreateIngressPointRequest.setter(Builder::ingressPointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointName").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfiguration").getter(CreateIngressPointRequest.getter(CreateIngressPointRequest::networkConfiguration)).setter(CreateIngressPointRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build()}).build();
    private static final SdkField<String> RULE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleSetId").getter(CreateIngressPointRequest.getter(CreateIngressPointRequest::ruleSetId)).setter(CreateIngressPointRequest.setter(Builder::ruleSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateIngressPointRequest.getter(CreateIngressPointRequest::tags)).setter(CreateIngressPointRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyId").getter(CreateIngressPointRequest.getter(CreateIngressPointRequest::trafficPolicyId)).setter(CreateIngressPointRequest.setter(Builder::trafficPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateIngressPointRequest.getter(CreateIngressPointRequest::typeAsString)).setter(CreateIngressPointRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, INGRESS_POINT_CONFIGURATION_FIELD, INGRESS_POINT_NAME_FIELD, NETWORK_CONFIGURATION_FIELD, RULE_SET_ID_FIELD, TAGS_FIELD, TRAFFIC_POLICY_ID_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIngressPointRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final IngressPointConfiguration ingressPointConfiguration;
    private final String ingressPointName;
    private final NetworkConfiguration networkConfiguration;
    private final String ruleSetId;
    private final List<Tag> tags;
    private final String trafficPolicyId;
    private final String type;

    private CreateIngressPointRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.ingressPointConfiguration = builder.ingressPointConfiguration;
        this.ingressPointName = builder.ingressPointName;
        this.networkConfiguration = builder.networkConfiguration;
        this.ruleSetId = builder.ruleSetId;
        this.tags = builder.tags;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.type = builder.type;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final IngressPointConfiguration ingressPointConfiguration() {
        return this.ingressPointConfiguration;
    }

    public final String ingressPointName() {
        return this.ingressPointName;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final String ruleSetId() {
        return this.ruleSetId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String trafficPolicyId() {
        return this.trafficPolicyId;
    }

    public final IngressPointType type() {
        return IngressPointType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIngressPointRequest)) {
            return false;
        }
        CreateIngressPointRequest other = (CreateIngressPointRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.ingressPointConfiguration(), other.ingressPointConfiguration()) && Objects.equals(this.ingressPointName(), other.ingressPointName()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.ruleSetId(), other.ruleSetId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.trafficPolicyId(), other.trafficPolicyId()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIngressPointRequest").add("ClientToken", (Object)this.clientToken()).add("IngressPointConfiguration", (Object)this.ingressPointConfiguration()).add("IngressPointName", (Object)this.ingressPointName()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("RuleSetId", (Object)this.ruleSetId()).add("Tags", this.hasTags() ? this.tags() : null).add("TrafficPolicyId", (Object)this.trafficPolicyId()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "IngressPointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ingressPointConfiguration()));
            }
            case "IngressPointName": {
                return Optional.ofNullable(clazz.cast(this.ingressPointName()));
            }
            case "NetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "RuleSetId": {
                return Optional.ofNullable(clazz.cast(this.ruleSetId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TrafficPolicyId": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("IngressPointConfiguration", INGRESS_POINT_CONFIGURATION_FIELD);
        map.put("IngressPointName", INGRESS_POINT_NAME_FIELD);
        map.put("NetworkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("RuleSetId", RULE_SET_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TrafficPolicyId", TRAFFIC_POLICY_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIngressPointRequest, T> g) {
        return obj -> g.apply((CreateIngressPointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private IngressPointConfiguration ingressPointConfiguration;
        private String ingressPointName;
        private NetworkConfiguration networkConfiguration;
        private String ruleSetId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String trafficPolicyId;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIngressPointRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.ingressPointConfiguration(model.ingressPointConfiguration);
            this.ingressPointName(model.ingressPointName);
            this.networkConfiguration(model.networkConfiguration);
            this.ruleSetId(model.ruleSetId);
            this.tags(model.tags);
            this.trafficPolicyId(model.trafficPolicyId);
            this.type(model.type);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final IngressPointConfiguration.Builder getIngressPointConfiguration() {
            return this.ingressPointConfiguration != null ? this.ingressPointConfiguration.toBuilder() : null;
        }

        public final void setIngressPointConfiguration(IngressPointConfiguration.BuilderImpl ingressPointConfiguration) {
            this.ingressPointConfiguration = ingressPointConfiguration != null ? ingressPointConfiguration.build() : null;
        }

        @Override
        public final Builder ingressPointConfiguration(IngressPointConfiguration ingressPointConfiguration) {
            this.ingressPointConfiguration = ingressPointConfiguration;
            return this;
        }

        public final String getIngressPointName() {
            return this.ingressPointName;
        }

        public final void setIngressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
        }

        @Override
        public final Builder ingressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getRuleSetId() {
            return this.ruleSetId;
        }

        public final void setRuleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
        }

        @Override
        public final Builder ruleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTrafficPolicyId() {
            return this.trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IngressPointType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIngressPointRequest build() {
            return new CreateIngressPointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MailManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIngressPointRequest> {
        public Builder clientToken(String var1);

        public Builder ingressPointConfiguration(IngressPointConfiguration var1);

        default public Builder ingressPointConfiguration(Consumer<IngressPointConfiguration.Builder> ingressPointConfiguration) {
            return this.ingressPointConfiguration((IngressPointConfiguration)((IngressPointConfiguration.Builder)IngressPointConfiguration.builder().applyMutation(ingressPointConfiguration)).build());
        }

        public Builder ingressPointName(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder ruleSetId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder trafficPolicyId(String var1);

        public Builder type(String var1);

        public Builder type(IngressPointType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

