/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.IngressPoint;
import software.amazon.awssdk.services.mailmanager.model.IngressPointsListCopier;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIngressPointsResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, ListIngressPointsResponse> {
    private static final SdkField<List<IngressPoint>> INGRESS_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IngressPoints").getter(ListIngressPointsResponse.getter(ListIngressPointsResponse::ingressPoints)).setter(ListIngressPointsResponse.setter(Builder::ingressPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IngressPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIngressPointsResponse.getter(ListIngressPointsResponse::nextToken)).setter(ListIngressPointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGRESS_POINTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIngressPointsResponse.memberNameToFieldInitializer();
    private final List<IngressPoint> ingressPoints;
    private final String nextToken;

    private ListIngressPointsResponse(BuilderImpl builder) {
        super(builder);
        this.ingressPoints = builder.ingressPoints;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIngressPoints() {
        return this.ingressPoints != null && !(this.ingressPoints instanceof SdkAutoConstructList);
    }

    public final List<IngressPoint> ingressPoints() {
        return this.ingressPoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIngressPoints() ? this.ingressPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngressPointsResponse)) {
            return false;
        }
        ListIngressPointsResponse other = (ListIngressPointsResponse)((Object)obj);
        return this.hasIngressPoints() == other.hasIngressPoints() && Objects.equals(this.ingressPoints(), other.ingressPoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIngressPointsResponse").add("IngressPoints", this.hasIngressPoints() ? this.ingressPoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IngressPoints": {
                return Optional.ofNullable(clazz.cast(this.ingressPoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IngressPoints", INGRESS_POINTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIngressPointsResponse, T> g) {
        return obj -> g.apply((ListIngressPointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private List<IngressPoint> ingressPoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIngressPointsResponse model) {
            super(model);
            this.ingressPoints(model.ingressPoints);
            this.nextToken(model.nextToken);
        }

        public final List<IngressPoint.Builder> getIngressPoints() {
            List<IngressPoint.Builder> result = IngressPointsListCopier.copyToBuilder(this.ingressPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngressPoints(Collection<IngressPoint.BuilderImpl> ingressPoints) {
            this.ingressPoints = IngressPointsListCopier.copyFromBuilder(ingressPoints);
        }

        @Override
        public final Builder ingressPoints(Collection<IngressPoint> ingressPoints) {
            this.ingressPoints = IngressPointsListCopier.copy(ingressPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPoints(IngressPoint ... ingressPoints) {
            this.ingressPoints(Arrays.asList(ingressPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPoints(Consumer<IngressPoint.Builder> ... ingressPoints) {
            this.ingressPoints(Stream.of(ingressPoints).map(c -> (IngressPoint)((IngressPoint.Builder)IngressPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIngressPointsResponse build() {
            return new ListIngressPointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIngressPointsResponse> {
        public Builder ingressPoints(Collection<IngressPoint> var1);

        public Builder ingressPoints(IngressPoint ... var1);

        public Builder ingressPoints(Consumer<IngressPoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

