/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.SavedAddress;

public class ListMembersOfAddressListIterable
implements SdkIterable<ListMembersOfAddressListResponse> {
    private final MailManagerClient client;
    private final ListMembersOfAddressListRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMembersOfAddressListIterable(MailManagerClient client, ListMembersOfAddressListRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMembersOfAddressListResponseFetcher();
    }

    public Iterator<ListMembersOfAddressListResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SavedAddress> addresses() {
        Function<ListMembersOfAddressListResponse, Iterator> getIterator = response -> {
            if (response != null && response.addresses() != null) {
                return response.addresses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMembersOfAddressListResponseFetcher
    implements SyncPageFetcher<ListMembersOfAddressListResponse> {
        private ListMembersOfAddressListResponseFetcher() {
        }

        public boolean hasNextPage(ListMembersOfAddressListResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMembersOfAddressListResponse nextPage(ListMembersOfAddressListResponse previousPage) {
            if (previousPage == null) {
                return ListMembersOfAddressListIterable.this.client.listMembersOfAddressList(ListMembersOfAddressListIterable.this.firstRequest);
            }
            return ListMembersOfAddressListIterable.this.client.listMembersOfAddressList((ListMembersOfAddressListRequest)((Object)ListMembersOfAddressListIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

