/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.AcceptAction;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.services.mailmanager.model.PolicyStatement;
import software.amazon.awssdk.services.mailmanager.model.PolicyStatementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTrafficPolicyResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, GetTrafficPolicyResponse> {
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(GetTrafficPolicyResponse.getter(GetTrafficPolicyResponse::createdTimestamp)).setter(GetTrafficPolicyResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<String> DEFAULT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultAction").getter(GetTrafficPolicyResponse.getter(GetTrafficPolicyResponse::defaultActionAsString)).setter(GetTrafficPolicyResponse.setter(Builder::defaultAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(GetTrafficPolicyResponse.getter(GetTrafficPolicyResponse::lastUpdatedTimestamp)).setter(GetTrafficPolicyResponse.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<Integer> MAX_MESSAGE_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxMessageSizeBytes").getter(GetTrafficPolicyResponse.getter(GetTrafficPolicyResponse::maxMessageSizeBytes)).setter(GetTrafficPolicyResponse.setter(Builder::maxMessageSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxMessageSizeBytes").build()}).build();
    private static final SdkField<List<PolicyStatement>> POLICY_STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyStatements").getter(GetTrafficPolicyResponse.getter(GetTrafficPolicyResponse::policyStatements)).setter(GetTrafficPolicyResponse.setter(Builder::policyStatements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyStatements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyArn").getter(GetTrafficPolicyResponse.getter(GetTrafficPolicyResponse::trafficPolicyArn)).setter(GetTrafficPolicyResponse.setter(Builder::trafficPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyArn").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyId").getter(GetTrafficPolicyResponse.getter(GetTrafficPolicyResponse::trafficPolicyId)).setter(GetTrafficPolicyResponse.setter(Builder::trafficPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyName").getter(GetTrafficPolicyResponse.getter(GetTrafficPolicyResponse::trafficPolicyName)).setter(GetTrafficPolicyResponse.setter(Builder::trafficPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIMESTAMP_FIELD, DEFAULT_ACTION_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, MAX_MESSAGE_SIZE_BYTES_FIELD, POLICY_STATEMENTS_FIELD, TRAFFIC_POLICY_ARN_FIELD, TRAFFIC_POLICY_ID_FIELD, TRAFFIC_POLICY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTrafficPolicyResponse.memberNameToFieldInitializer();
    private final Instant createdTimestamp;
    private final String defaultAction;
    private final Instant lastUpdatedTimestamp;
    private final Integer maxMessageSizeBytes;
    private final List<PolicyStatement> policyStatements;
    private final String trafficPolicyArn;
    private final String trafficPolicyId;
    private final String trafficPolicyName;

    private GetTrafficPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.createdTimestamp = builder.createdTimestamp;
        this.defaultAction = builder.defaultAction;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.maxMessageSizeBytes = builder.maxMessageSizeBytes;
        this.policyStatements = builder.policyStatements;
        this.trafficPolicyArn = builder.trafficPolicyArn;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyName = builder.trafficPolicyName;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final AcceptAction defaultAction() {
        return AcceptAction.fromValue(this.defaultAction);
    }

    public final String defaultActionAsString() {
        return this.defaultAction;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final Integer maxMessageSizeBytes() {
        return this.maxMessageSizeBytes;
    }

    public final boolean hasPolicyStatements() {
        return this.policyStatements != null && !(this.policyStatements instanceof SdkAutoConstructList);
    }

    public final List<PolicyStatement> policyStatements() {
        return this.policyStatements;
    }

    public final String trafficPolicyArn() {
        return this.trafficPolicyArn;
    }

    public final String trafficPolicyId() {
        return this.trafficPolicyId;
    }

    public final String trafficPolicyName() {
        return this.trafficPolicyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxMessageSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyStatements() ? this.policyStatements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrafficPolicyResponse)) {
            return false;
        }
        GetTrafficPolicyResponse other = (GetTrafficPolicyResponse)((Object)obj);
        return Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.defaultActionAsString(), other.defaultActionAsString()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.maxMessageSizeBytes(), other.maxMessageSizeBytes()) && this.hasPolicyStatements() == other.hasPolicyStatements() && Objects.equals(this.policyStatements(), other.policyStatements()) && Objects.equals(this.trafficPolicyArn(), other.trafficPolicyArn()) && Objects.equals(this.trafficPolicyId(), other.trafficPolicyId()) && Objects.equals(this.trafficPolicyName(), other.trafficPolicyName());
    }

    public final String toString() {
        return ToString.builder((String)"GetTrafficPolicyResponse").add("CreatedTimestamp", (Object)this.createdTimestamp()).add("DefaultAction", (Object)this.defaultActionAsString()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("MaxMessageSizeBytes", (Object)this.maxMessageSizeBytes()).add("PolicyStatements", this.hasPolicyStatements() ? this.policyStatements() : null).add("TrafficPolicyArn", (Object)this.trafficPolicyArn()).add("TrafficPolicyId", (Object)this.trafficPolicyId()).add("TrafficPolicyName", (Object)this.trafficPolicyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "DefaultAction": {
                return Optional.ofNullable(clazz.cast(this.defaultActionAsString()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "MaxMessageSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.maxMessageSizeBytes()));
            }
            case "PolicyStatements": {
                return Optional.ofNullable(clazz.cast(this.policyStatements()));
            }
            case "TrafficPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyArn()));
            }
            case "TrafficPolicyId": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyId()));
            }
            case "TrafficPolicyName": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("DefaultAction", DEFAULT_ACTION_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        map.put("MaxMessageSizeBytes", MAX_MESSAGE_SIZE_BYTES_FIELD);
        map.put("PolicyStatements", POLICY_STATEMENTS_FIELD);
        map.put("TrafficPolicyArn", TRAFFIC_POLICY_ARN_FIELD);
        map.put("TrafficPolicyId", TRAFFIC_POLICY_ID_FIELD);
        map.put("TrafficPolicyName", TRAFFIC_POLICY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTrafficPolicyResponse, T> g) {
        return obj -> g.apply((GetTrafficPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private Instant createdTimestamp;
        private String defaultAction;
        private Instant lastUpdatedTimestamp;
        private Integer maxMessageSizeBytes;
        private List<PolicyStatement> policyStatements = DefaultSdkAutoConstructList.getInstance();
        private String trafficPolicyArn;
        private String trafficPolicyId;
        private String trafficPolicyName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrafficPolicyResponse model) {
            super(model);
            this.createdTimestamp(model.createdTimestamp);
            this.defaultAction(model.defaultAction);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.maxMessageSizeBytes(model.maxMessageSizeBytes);
            this.policyStatements(model.policyStatements);
            this.trafficPolicyArn(model.trafficPolicyArn);
            this.trafficPolicyId(model.trafficPolicyId);
            this.trafficPolicyName(model.trafficPolicyName);
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getDefaultAction() {
            return this.defaultAction;
        }

        public final void setDefaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
        }

        @Override
        public final Builder defaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        @Override
        public final Builder defaultAction(AcceptAction defaultAction) {
            this.defaultAction(defaultAction == null ? null : defaultAction.toString());
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final Integer getMaxMessageSizeBytes() {
            return this.maxMessageSizeBytes;
        }

        public final void setMaxMessageSizeBytes(Integer maxMessageSizeBytes) {
            this.maxMessageSizeBytes = maxMessageSizeBytes;
        }

        @Override
        public final Builder maxMessageSizeBytes(Integer maxMessageSizeBytes) {
            this.maxMessageSizeBytes = maxMessageSizeBytes;
            return this;
        }

        public final List<PolicyStatement.Builder> getPolicyStatements() {
            List<PolicyStatement.Builder> result = PolicyStatementListCopier.copyToBuilder(this.policyStatements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyStatements(Collection<PolicyStatement.BuilderImpl> policyStatements) {
            this.policyStatements = PolicyStatementListCopier.copyFromBuilder(policyStatements);
        }

        @Override
        public final Builder policyStatements(Collection<PolicyStatement> policyStatements) {
            this.policyStatements = PolicyStatementListCopier.copy(policyStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyStatements(PolicyStatement ... policyStatements) {
            this.policyStatements(Arrays.asList(policyStatements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyStatements(Consumer<PolicyStatement.Builder> ... policyStatements) {
            this.policyStatements(Stream.of(policyStatements).map(c -> (PolicyStatement)((PolicyStatement.Builder)PolicyStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTrafficPolicyArn() {
            return this.trafficPolicyArn;
        }

        public final void setTrafficPolicyArn(String trafficPolicyArn) {
            this.trafficPolicyArn = trafficPolicyArn;
        }

        @Override
        public final Builder trafficPolicyArn(String trafficPolicyArn) {
            this.trafficPolicyArn = trafficPolicyArn;
            return this;
        }

        public final String getTrafficPolicyId() {
            return this.trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final String getTrafficPolicyName() {
            return this.trafficPolicyName;
        }

        public final void setTrafficPolicyName(String trafficPolicyName) {
            this.trafficPolicyName = trafficPolicyName;
        }

        @Override
        public final Builder trafficPolicyName(String trafficPolicyName) {
            this.trafficPolicyName = trafficPolicyName;
            return this;
        }

        @Override
        public GetTrafficPolicyResponse build() {
            return new GetTrafficPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTrafficPolicyResponse> {
        public Builder createdTimestamp(Instant var1);

        public Builder defaultAction(String var1);

        public Builder defaultAction(AcceptAction var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder maxMessageSizeBytes(Integer var1);

        public Builder policyStatements(Collection<PolicyStatement> var1);

        public Builder policyStatements(PolicyStatement ... var1);

        public Builder policyStatements(Consumer<PolicyStatement.Builder> ... var1);

        public Builder trafficPolicyArn(String var1);

        public Builder trafficPolicyId(String var1);

        public Builder trafficPolicyName(String var1);
    }
}

