/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.IngressPointConfiguration;
import software.amazon.awssdk.services.mailmanager.model.IngressPointStatusToUpdate;
import software.amazon.awssdk.services.mailmanager.model.MailManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIngressPointRequest
extends MailManagerRequest
implements ToCopyableBuilder<Builder, UpdateIngressPointRequest> {
    private static final SdkField<IngressPointConfiguration> INGRESS_POINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngressPointConfiguration").getter(UpdateIngressPointRequest.getter(UpdateIngressPointRequest::ingressPointConfiguration)).setter(UpdateIngressPointRequest.setter(Builder::ingressPointConfiguration)).constructor(IngressPointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointConfiguration").build()}).build();
    private static final SdkField<String> INGRESS_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngressPointId").getter(UpdateIngressPointRequest.getter(UpdateIngressPointRequest::ingressPointId)).setter(UpdateIngressPointRequest.setter(Builder::ingressPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointId").build()}).build();
    private static final SdkField<String> INGRESS_POINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngressPointName").getter(UpdateIngressPointRequest.getter(UpdateIngressPointRequest::ingressPointName)).setter(UpdateIngressPointRequest.setter(Builder::ingressPointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointName").build()}).build();
    private static final SdkField<String> RULE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleSetId").getter(UpdateIngressPointRequest.getter(UpdateIngressPointRequest::ruleSetId)).setter(UpdateIngressPointRequest.setter(Builder::ruleSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetId").build()}).build();
    private static final SdkField<String> STATUS_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusToUpdate").getter(UpdateIngressPointRequest.getter(UpdateIngressPointRequest::statusToUpdateAsString)).setter(UpdateIngressPointRequest.setter(Builder::statusToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusToUpdate").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyId").getter(UpdateIngressPointRequest.getter(UpdateIngressPointRequest::trafficPolicyId)).setter(UpdateIngressPointRequest.setter(Builder::trafficPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGRESS_POINT_CONFIGURATION_FIELD, INGRESS_POINT_ID_FIELD, INGRESS_POINT_NAME_FIELD, RULE_SET_ID_FIELD, STATUS_TO_UPDATE_FIELD, TRAFFIC_POLICY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateIngressPointRequest.memberNameToFieldInitializer();
    private final IngressPointConfiguration ingressPointConfiguration;
    private final String ingressPointId;
    private final String ingressPointName;
    private final String ruleSetId;
    private final String statusToUpdate;
    private final String trafficPolicyId;

    private UpdateIngressPointRequest(BuilderImpl builder) {
        super(builder);
        this.ingressPointConfiguration = builder.ingressPointConfiguration;
        this.ingressPointId = builder.ingressPointId;
        this.ingressPointName = builder.ingressPointName;
        this.ruleSetId = builder.ruleSetId;
        this.statusToUpdate = builder.statusToUpdate;
        this.trafficPolicyId = builder.trafficPolicyId;
    }

    public final IngressPointConfiguration ingressPointConfiguration() {
        return this.ingressPointConfiguration;
    }

    public final String ingressPointId() {
        return this.ingressPointId;
    }

    public final String ingressPointName() {
        return this.ingressPointName;
    }

    public final String ruleSetId() {
        return this.ruleSetId;
    }

    public final IngressPointStatusToUpdate statusToUpdate() {
        return IngressPointStatusToUpdate.fromValue(this.statusToUpdate);
    }

    public final String statusToUpdateAsString() {
        return this.statusToUpdate;
    }

    public final String trafficPolicyId() {
        return this.trafficPolicyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusToUpdateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIngressPointRequest)) {
            return false;
        }
        UpdateIngressPointRequest other = (UpdateIngressPointRequest)((Object)obj);
        return Objects.equals(this.ingressPointConfiguration(), other.ingressPointConfiguration()) && Objects.equals(this.ingressPointId(), other.ingressPointId()) && Objects.equals(this.ingressPointName(), other.ingressPointName()) && Objects.equals(this.ruleSetId(), other.ruleSetId()) && Objects.equals(this.statusToUpdateAsString(), other.statusToUpdateAsString()) && Objects.equals(this.trafficPolicyId(), other.trafficPolicyId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIngressPointRequest").add("IngressPointConfiguration", (Object)this.ingressPointConfiguration()).add("IngressPointId", (Object)this.ingressPointId()).add("IngressPointName", (Object)this.ingressPointName()).add("RuleSetId", (Object)this.ruleSetId()).add("StatusToUpdate", (Object)this.statusToUpdateAsString()).add("TrafficPolicyId", (Object)this.trafficPolicyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IngressPointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ingressPointConfiguration()));
            }
            case "IngressPointId": {
                return Optional.ofNullable(clazz.cast(this.ingressPointId()));
            }
            case "IngressPointName": {
                return Optional.ofNullable(clazz.cast(this.ingressPointName()));
            }
            case "RuleSetId": {
                return Optional.ofNullable(clazz.cast(this.ruleSetId()));
            }
            case "StatusToUpdate": {
                return Optional.ofNullable(clazz.cast(this.statusToUpdateAsString()));
            }
            case "TrafficPolicyId": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IngressPointConfiguration", INGRESS_POINT_CONFIGURATION_FIELD);
        map.put("IngressPointId", INGRESS_POINT_ID_FIELD);
        map.put("IngressPointName", INGRESS_POINT_NAME_FIELD);
        map.put("RuleSetId", RULE_SET_ID_FIELD);
        map.put("StatusToUpdate", STATUS_TO_UPDATE_FIELD);
        map.put("TrafficPolicyId", TRAFFIC_POLICY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIngressPointRequest, T> g) {
        return obj -> g.apply((UpdateIngressPointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerRequest.BuilderImpl
    implements Builder {
        private IngressPointConfiguration ingressPointConfiguration;
        private String ingressPointId;
        private String ingressPointName;
        private String ruleSetId;
        private String statusToUpdate;
        private String trafficPolicyId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIngressPointRequest model) {
            super(model);
            this.ingressPointConfiguration(model.ingressPointConfiguration);
            this.ingressPointId(model.ingressPointId);
            this.ingressPointName(model.ingressPointName);
            this.ruleSetId(model.ruleSetId);
            this.statusToUpdate(model.statusToUpdate);
            this.trafficPolicyId(model.trafficPolicyId);
        }

        public final IngressPointConfiguration.Builder getIngressPointConfiguration() {
            return this.ingressPointConfiguration != null ? this.ingressPointConfiguration.toBuilder() : null;
        }

        public final void setIngressPointConfiguration(IngressPointConfiguration.BuilderImpl ingressPointConfiguration) {
            this.ingressPointConfiguration = ingressPointConfiguration != null ? ingressPointConfiguration.build() : null;
        }

        @Override
        public final Builder ingressPointConfiguration(IngressPointConfiguration ingressPointConfiguration) {
            this.ingressPointConfiguration = ingressPointConfiguration;
            return this;
        }

        public final String getIngressPointId() {
            return this.ingressPointId;
        }

        public final void setIngressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
        }

        @Override
        public final Builder ingressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
            return this;
        }

        public final String getIngressPointName() {
            return this.ingressPointName;
        }

        public final void setIngressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
        }

        @Override
        public final Builder ingressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
            return this;
        }

        public final String getRuleSetId() {
            return this.ruleSetId;
        }

        public final void setRuleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
        }

        @Override
        public final Builder ruleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        public final String getStatusToUpdate() {
            return this.statusToUpdate;
        }

        public final void setStatusToUpdate(String statusToUpdate) {
            this.statusToUpdate = statusToUpdate;
        }

        @Override
        public final Builder statusToUpdate(String statusToUpdate) {
            this.statusToUpdate = statusToUpdate;
            return this;
        }

        @Override
        public final Builder statusToUpdate(IngressPointStatusToUpdate statusToUpdate) {
            this.statusToUpdate(statusToUpdate == null ? null : statusToUpdate.toString());
            return this;
        }

        public final String getTrafficPolicyId() {
            return this.trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIngressPointRequest build() {
            return new UpdateIngressPointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MailManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIngressPointRequest> {
        public Builder ingressPointConfiguration(IngressPointConfiguration var1);

        default public Builder ingressPointConfiguration(Consumer<IngressPointConfiguration.Builder> ingressPointConfiguration) {
            return this.ingressPointConfiguration((IngressPointConfiguration)((IngressPointConfiguration.Builder)IngressPointConfiguration.builder().applyMutation(ingressPointConfiguration)).build());
        }

        public Builder ingressPointId(String var1);

        public Builder ingressPointName(String var1);

        public Builder ruleSetId(String var1);

        public Builder statusToUpdate(String var1);

        public Builder statusToUpdate(IngressPointStatusToUpdate var1);

        public Builder trafficPolicyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

