/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.ArchiveRetention;
import software.amazon.awssdk.services.mailmanager.model.MailManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateArchiveRequest
extends MailManagerRequest
implements ToCopyableBuilder<Builder, UpdateArchiveRequest> {
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveId").getter(UpdateArchiveRequest.getter(UpdateArchiveRequest::archiveId)).setter(UpdateArchiveRequest.setter(Builder::archiveId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()}).build();
    private static final SdkField<String> ARCHIVE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveName").getter(UpdateArchiveRequest.getter(UpdateArchiveRequest::archiveName)).setter(UpdateArchiveRequest.setter(Builder::archiveName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveName").build()}).build();
    private static final SdkField<ArchiveRetention> RETENTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Retention").getter(UpdateArchiveRequest.getter(UpdateArchiveRequest::retention)).setter(UpdateArchiveRequest.setter(Builder::retention)).constructor(ArchiveRetention::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retention").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ID_FIELD, ARCHIVE_NAME_FIELD, RETENTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateArchiveRequest.memberNameToFieldInitializer();
    private final String archiveId;
    private final String archiveName;
    private final ArchiveRetention retention;

    private UpdateArchiveRequest(BuilderImpl builder) {
        super(builder);
        this.archiveId = builder.archiveId;
        this.archiveName = builder.archiveName;
        this.retention = builder.retention;
    }

    public final String archiveId() {
        return this.archiveId;
    }

    public final String archiveName() {
        return this.archiveName;
    }

    public final ArchiveRetention retention() {
        return this.retention;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveName());
        hashCode = 31 * hashCode + Objects.hashCode(this.retention());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateArchiveRequest)) {
            return false;
        }
        UpdateArchiveRequest other = (UpdateArchiveRequest)((Object)obj);
        return Objects.equals(this.archiveId(), other.archiveId()) && Objects.equals(this.archiveName(), other.archiveName()) && Objects.equals(this.retention(), other.retention());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateArchiveRequest").add("ArchiveId", (Object)this.archiveId()).add("ArchiveName", (Object)this.archiveName()).add("Retention", (Object)this.retention()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveId": {
                return Optional.ofNullable(clazz.cast(this.archiveId()));
            }
            case "ArchiveName": {
                return Optional.ofNullable(clazz.cast(this.archiveName()));
            }
            case "Retention": {
                return Optional.ofNullable(clazz.cast(this.retention()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ArchiveId", ARCHIVE_ID_FIELD);
        map.put("ArchiveName", ARCHIVE_NAME_FIELD);
        map.put("Retention", RETENTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateArchiveRequest, T> g) {
        return obj -> g.apply((UpdateArchiveRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerRequest.BuilderImpl
    implements Builder {
        private String archiveId;
        private String archiveName;
        private ArchiveRetention retention;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateArchiveRequest model) {
            super(model);
            this.archiveId(model.archiveId);
            this.archiveName(model.archiveName);
            this.retention(model.retention);
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final String getArchiveName() {
            return this.archiveName;
        }

        public final void setArchiveName(String archiveName) {
            this.archiveName = archiveName;
        }

        @Override
        public final Builder archiveName(String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        public final ArchiveRetention.Builder getRetention() {
            return this.retention != null ? this.retention.toBuilder() : null;
        }

        public final void setRetention(ArchiveRetention.BuilderImpl retention) {
            this.retention = retention != null ? retention.build() : null;
        }

        @Override
        public final Builder retention(ArchiveRetention retention) {
            this.retention = retention;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateArchiveRequest build() {
            return new UpdateArchiveRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MailManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateArchiveRequest> {
        public Builder archiveId(String var1);

        public Builder archiveName(String var1);

        public Builder retention(ArchiveRetention var1);

        default public Builder retention(Consumer<ArchiveRetention.Builder> retention) {
            return this.retention((ArchiveRetention)((ArchiveRetention.Builder)ArchiveRetention.builder().applyMutation(retention)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

