/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.ArchiveFilters;
import software.amazon.awssdk.services.mailmanager.model.ExportDestinationConfiguration;
import software.amazon.awssdk.services.mailmanager.model.MailManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartArchiveExportRequest
extends MailManagerRequest
implements ToCopyableBuilder<Builder, StartArchiveExportRequest> {
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveId").getter(StartArchiveExportRequest.getter(StartArchiveExportRequest::archiveId)).setter(StartArchiveExportRequest.setter(Builder::archiveId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()}).build();
    private static final SdkField<ExportDestinationConfiguration> EXPORT_DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportDestinationConfiguration").getter(StartArchiveExportRequest.getter(StartArchiveExportRequest::exportDestinationConfiguration)).setter(StartArchiveExportRequest.setter(Builder::exportDestinationConfiguration)).constructor(ExportDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDestinationConfiguration").build()}).build();
    private static final SdkField<ArchiveFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(StartArchiveExportRequest.getter(StartArchiveExportRequest::filters)).setter(StartArchiveExportRequest.setter(Builder::filters)).constructor(ArchiveFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<Instant> FROM_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FromTimestamp").getter(StartArchiveExportRequest.getter(StartArchiveExportRequest::fromTimestamp)).setter(StartArchiveExportRequest.setter(Builder::fromTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromTimestamp").build()}).build();
    private static final SdkField<Boolean> INCLUDE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeMetadata").getter(StartArchiveExportRequest.getter(StartArchiveExportRequest::includeMetadata)).setter(StartArchiveExportRequest.setter(Builder::includeMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMetadata").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(StartArchiveExportRequest.getter(StartArchiveExportRequest::maxResults)).setter(StartArchiveExportRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Instant> TO_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ToTimestamp").getter(StartArchiveExportRequest.getter(StartArchiveExportRequest::toTimestamp)).setter(StartArchiveExportRequest.setter(Builder::toTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ID_FIELD, EXPORT_DESTINATION_CONFIGURATION_FIELD, FILTERS_FIELD, FROM_TIMESTAMP_FIELD, INCLUDE_METADATA_FIELD, MAX_RESULTS_FIELD, TO_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartArchiveExportRequest.memberNameToFieldInitializer();
    private final String archiveId;
    private final ExportDestinationConfiguration exportDestinationConfiguration;
    private final ArchiveFilters filters;
    private final Instant fromTimestamp;
    private final Boolean includeMetadata;
    private final Integer maxResults;
    private final Instant toTimestamp;

    private StartArchiveExportRequest(BuilderImpl builder) {
        super(builder);
        this.archiveId = builder.archiveId;
        this.exportDestinationConfiguration = builder.exportDestinationConfiguration;
        this.filters = builder.filters;
        this.fromTimestamp = builder.fromTimestamp;
        this.includeMetadata = builder.includeMetadata;
        this.maxResults = builder.maxResults;
        this.toTimestamp = builder.toTimestamp;
    }

    public final String archiveId() {
        return this.archiveId;
    }

    public final ExportDestinationConfiguration exportDestinationConfiguration() {
        return this.exportDestinationConfiguration;
    }

    public final ArchiveFilters filters() {
        return this.filters;
    }

    public final Instant fromTimestamp() {
        return this.fromTimestamp;
    }

    public final Boolean includeMetadata() {
        return this.includeMetadata;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Instant toTimestamp() {
        return this.toTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.toTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartArchiveExportRequest)) {
            return false;
        }
        StartArchiveExportRequest other = (StartArchiveExportRequest)((Object)obj);
        return Objects.equals(this.archiveId(), other.archiveId()) && Objects.equals(this.exportDestinationConfiguration(), other.exportDestinationConfiguration()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.fromTimestamp(), other.fromTimestamp()) && Objects.equals(this.includeMetadata(), other.includeMetadata()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.toTimestamp(), other.toTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"StartArchiveExportRequest").add("ArchiveId", (Object)this.archiveId()).add("ExportDestinationConfiguration", (Object)this.exportDestinationConfiguration()).add("Filters", (Object)this.filters()).add("FromTimestamp", (Object)this.fromTimestamp()).add("IncludeMetadata", (Object)this.includeMetadata()).add("MaxResults", (Object)this.maxResults()).add("ToTimestamp", (Object)this.toTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveId": {
                return Optional.ofNullable(clazz.cast(this.archiveId()));
            }
            case "ExportDestinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.exportDestinationConfiguration()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "FromTimestamp": {
                return Optional.ofNullable(clazz.cast(this.fromTimestamp()));
            }
            case "IncludeMetadata": {
                return Optional.ofNullable(clazz.cast(this.includeMetadata()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ToTimestamp": {
                return Optional.ofNullable(clazz.cast(this.toTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ArchiveId", ARCHIVE_ID_FIELD);
        map.put("ExportDestinationConfiguration", EXPORT_DESTINATION_CONFIGURATION_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("FromTimestamp", FROM_TIMESTAMP_FIELD);
        map.put("IncludeMetadata", INCLUDE_METADATA_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("ToTimestamp", TO_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartArchiveExportRequest, T> g) {
        return obj -> g.apply((StartArchiveExportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerRequest.BuilderImpl
    implements Builder {
        private String archiveId;
        private ExportDestinationConfiguration exportDestinationConfiguration;
        private ArchiveFilters filters;
        private Instant fromTimestamp;
        private Boolean includeMetadata;
        private Integer maxResults;
        private Instant toTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StartArchiveExportRequest model) {
            super(model);
            this.archiveId(model.archiveId);
            this.exportDestinationConfiguration(model.exportDestinationConfiguration);
            this.filters(model.filters);
            this.fromTimestamp(model.fromTimestamp);
            this.includeMetadata(model.includeMetadata);
            this.maxResults(model.maxResults);
            this.toTimestamp(model.toTimestamp);
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final ExportDestinationConfiguration.Builder getExportDestinationConfiguration() {
            return this.exportDestinationConfiguration != null ? this.exportDestinationConfiguration.toBuilder() : null;
        }

        public final void setExportDestinationConfiguration(ExportDestinationConfiguration.BuilderImpl exportDestinationConfiguration) {
            this.exportDestinationConfiguration = exportDestinationConfiguration != null ? exportDestinationConfiguration.build() : null;
        }

        @Override
        public final Builder exportDestinationConfiguration(ExportDestinationConfiguration exportDestinationConfiguration) {
            this.exportDestinationConfiguration = exportDestinationConfiguration;
            return this;
        }

        public final ArchiveFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(ArchiveFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ArchiveFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Instant getFromTimestamp() {
            return this.fromTimestamp;
        }

        public final void setFromTimestamp(Instant fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
        }

        @Override
        public final Builder fromTimestamp(Instant fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
            return this;
        }

        public final Boolean getIncludeMetadata() {
            return this.includeMetadata;
        }

        public final void setIncludeMetadata(Boolean includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        @Override
        public final Builder includeMetadata(Boolean includeMetadata) {
            this.includeMetadata = includeMetadata;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getToTimestamp() {
            return this.toTimestamp;
        }

        public final void setToTimestamp(Instant toTimestamp) {
            this.toTimestamp = toTimestamp;
        }

        @Override
        public final Builder toTimestamp(Instant toTimestamp) {
            this.toTimestamp = toTimestamp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartArchiveExportRequest build() {
            return new StartArchiveExportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MailManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartArchiveExportRequest> {
        public Builder archiveId(String var1);

        public Builder exportDestinationConfiguration(ExportDestinationConfiguration var1);

        default public Builder exportDestinationConfiguration(Consumer<ExportDestinationConfiguration.Builder> exportDestinationConfiguration) {
            return this.exportDestinationConfiguration((ExportDestinationConfiguration)((ExportDestinationConfiguration.Builder)ExportDestinationConfiguration.builder().applyMutation(exportDestinationConfiguration)).build());
        }

        public Builder filters(ArchiveFilters var1);

        default public Builder filters(Consumer<ArchiveFilters.Builder> filters) {
            return this.filters((ArchiveFilters)((ArchiveFilters.Builder)ArchiveFilters.builder().applyMutation(filters)).build());
        }

        public Builder fromTimestamp(Instant var1);

        public Builder includeMetadata(Boolean var1);

        public Builder maxResults(Integer var1);

        public Builder toTimestamp(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

