/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mailmanager.model.IngressIpv6Attribute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngressIpv6ToEvaluate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngressIpv6ToEvaluate> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(IngressIpv6ToEvaluate.getter(IngressIpv6ToEvaluate::attributeAsString)).setter(IngressIpv6ToEvaluate.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IngressIpv6ToEvaluate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attribute;
    private final Type type;

    private IngressIpv6ToEvaluate(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.type = builder.type;
    }

    public final IngressIpv6Attribute attribute() {
        return IngressIpv6Attribute.fromValue(this.attribute);
    }

    public final String attributeAsString() {
        return this.attribute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressIpv6ToEvaluate)) {
            return false;
        }
        IngressIpv6ToEvaluate other = (IngressIpv6ToEvaluate)obj;
        return Objects.equals(this.attributeAsString(), other.attributeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IngressIpv6ToEvaluate").add("Attribute", (Object)this.attributeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
        }
        return Optional.empty();
    }

    public static IngressIpv6ToEvaluate fromAttribute(String attribute) {
        return (IngressIpv6ToEvaluate)IngressIpv6ToEvaluate.builder().attribute(attribute).build();
    }

    public static IngressIpv6ToEvaluate fromAttribute(IngressIpv6Attribute attribute) {
        return (IngressIpv6ToEvaluate)IngressIpv6ToEvaluate.builder().attribute(attribute).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Attribute", ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressIpv6ToEvaluate, T> g) {
        return obj -> g.apply((IngressIpv6ToEvaluate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ATTRIBUTE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IngressIpv6ToEvaluate model) {
            this.attribute(model.attribute);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            String oldValue = this.attribute;
            this.attribute = attribute;
            this.handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
        }

        @Override
        public final Builder attribute(String attribute) {
            String oldValue = this.attribute;
            this.attribute = attribute;
            this.handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
            return this;
        }

        @Override
        public final Builder attribute(IngressIpv6Attribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public IngressIpv6ToEvaluate build() {
            return new IngressIpv6ToEvaluate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngressIpv6ToEvaluate> {
        public Builder attribute(String var1);

        public Builder attribute(IngressIpv6Attribute var1);
    }
}

