/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ImportJob;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsResponse;

public class ListAddressListImportJobsIterable
implements SdkIterable<ListAddressListImportJobsResponse> {
    private final MailManagerClient client;
    private final ListAddressListImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAddressListImportJobsIterable(MailManagerClient client, ListAddressListImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAddressListImportJobsResponseFetcher();
    }

    public Iterator<ListAddressListImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImportJob> importJobs() {
        Function<ListAddressListImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.importJobs() != null) {
                return response.importJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAddressListImportJobsResponseFetcher
    implements SyncPageFetcher<ListAddressListImportJobsResponse> {
        private ListAddressListImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListAddressListImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAddressListImportJobsResponse nextPage(ListAddressListImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListAddressListImportJobsIterable.this.client.listAddressListImportJobs(ListAddressListImportJobsIterable.this.firstRequest);
            }
            return ListAddressListImportJobsIterable.this.client.listAddressListImportJobs((ListAddressListImportJobsRequest)((Object)ListAddressListImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

