/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerAsyncClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.AddonSubscription;
import software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsResponse;

public class ListAddonSubscriptionsPublisher
implements SdkPublisher<ListAddonSubscriptionsResponse> {
    private final MailManagerAsyncClient client;
    private final ListAddonSubscriptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAddonSubscriptionsPublisher(MailManagerAsyncClient client, ListAddonSubscriptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAddonSubscriptionsPublisher(MailManagerAsyncClient client, ListAddonSubscriptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAddonSubscriptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAddonSubscriptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AddonSubscription> addonSubscriptions() {
        Function<ListAddonSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.addonSubscriptions() != null) {
                return response.addonSubscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAddonSubscriptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAddonSubscriptionsResponseFetcher
    implements AsyncPageFetcher<ListAddonSubscriptionsResponse> {
        private ListAddonSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAddonSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAddonSubscriptionsResponse> nextPage(ListAddonSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListAddonSubscriptionsPublisher.this.client.listAddonSubscriptions(ListAddonSubscriptionsPublisher.this.firstRequest);
            }
            return ListAddonSubscriptionsPublisher.this.client.listAddonSubscriptions((ListAddonSubscriptionsRequest)((Object)ListAddonSubscriptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

