/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.ExportSummary;
import software.amazon.awssdk.services.mailmanager.model.ExportSummaryListCopier;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListArchiveExportsResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, ListArchiveExportsResponse> {
    private static final SdkField<List<ExportSummary>> EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Exports").getter(ListArchiveExportsResponse.getter(ListArchiveExportsResponse::exports)).setter(ListArchiveExportsResponse.setter(Builder::exports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListArchiveExportsResponse.getter(ListArchiveExportsResponse::nextToken)).setter(ListArchiveExportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListArchiveExportsResponse.memberNameToFieldInitializer();
    private final List<ExportSummary> exports;
    private final String nextToken;

    private ListArchiveExportsResponse(BuilderImpl builder) {
        super(builder);
        this.exports = builder.exports;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExports() {
        return this.exports != null && !(this.exports instanceof SdkAutoConstructList);
    }

    public final List<ExportSummary> exports() {
        return this.exports;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExports() ? this.exports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArchiveExportsResponse)) {
            return false;
        }
        ListArchiveExportsResponse other = (ListArchiveExportsResponse)((Object)obj);
        return this.hasExports() == other.hasExports() && Objects.equals(this.exports(), other.exports()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListArchiveExportsResponse").add("Exports", this.hasExports() ? this.exports() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Exports": {
                return Optional.ofNullable(clazz.cast(this.exports()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Exports", EXPORTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListArchiveExportsResponse, T> g) {
        return obj -> g.apply((ListArchiveExportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private List<ExportSummary> exports = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArchiveExportsResponse model) {
            super(model);
            this.exports(model.exports);
            this.nextToken(model.nextToken);
        }

        public final List<ExportSummary.Builder> getExports() {
            List<ExportSummary.Builder> result = ExportSummaryListCopier.copyToBuilder(this.exports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExports(Collection<ExportSummary.BuilderImpl> exports) {
            this.exports = ExportSummaryListCopier.copyFromBuilder(exports);
        }

        @Override
        public final Builder exports(Collection<ExportSummary> exports) {
            this.exports = ExportSummaryListCopier.copy(exports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exports(ExportSummary ... exports) {
            this.exports(Arrays.asList(exports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exports(Consumer<ExportSummary.Builder> ... exports) {
            this.exports(Stream.of(exports).map(c -> (ExportSummary)((ExportSummary.Builder)ExportSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListArchiveExportsResponse build() {
            return new ListArchiveExportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListArchiveExportsResponse> {
        public Builder exports(Collection<ExportSummary> var1);

        public Builder exports(ExportSummary ... var1);

        public Builder exports(Consumer<ExportSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

