/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.services.mailmanager.model.Relay;
import software.amazon.awssdk.services.mailmanager.model.RelaysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRelaysResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, ListRelaysResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRelaysResponse.getter(ListRelaysResponse::nextToken)).setter(ListRelaysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Relay>> RELAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Relays").getter(ListRelaysResponse.getter(ListRelaysResponse::relays)).setter(ListRelaysResponse.setter(Builder::relays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relays").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Relay::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RELAYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Relays", RELAYS_FIELD);
        }
    });
    private final String nextToken;
    private final List<Relay> relays;

    private ListRelaysResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.relays = builder.relays;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRelays() {
        return this.relays != null && !(this.relays instanceof SdkAutoConstructList);
    }

    public final List<Relay> relays() {
        return this.relays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelays() ? this.relays() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRelaysResponse)) {
            return false;
        }
        ListRelaysResponse other = (ListRelaysResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRelays() == other.hasRelays() && Objects.equals(this.relays(), other.relays());
    }

    public final String toString() {
        return ToString.builder((String)"ListRelaysResponse").add("NextToken", (Object)this.nextToken()).add("Relays", this.hasRelays() ? this.relays() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Relays": {
                return Optional.ofNullable(clazz.cast(this.relays()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRelaysResponse, T> g) {
        return obj -> g.apply((ListRelaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Relay> relays = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRelaysResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.relays(model.relays);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Relay.Builder> getRelays() {
            List<Relay.Builder> result = RelaysCopier.copyToBuilder(this.relays);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelays(Collection<Relay.BuilderImpl> relays) {
            this.relays = RelaysCopier.copyFromBuilder(relays);
        }

        @Override
        public final Builder relays(Collection<Relay> relays) {
            this.relays = RelaysCopier.copy(relays);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relays(Relay ... relays) {
            this.relays(Arrays.asList(relays));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relays(Consumer<Relay.Builder> ... relays) {
            this.relays(Stream.of(relays).map(c -> (Relay)((Relay.Builder)Relay.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRelaysResponse build() {
            return new ListRelaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRelaysResponse> {
        public Builder nextToken(String var1);

        public Builder relays(Collection<Relay> var1);

        public Builder relays(Relay ... var1);

        public Builder relays(Consumer<Relay.Builder> ... var1);
    }
}

