/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.services.mailmanager.model.SearchSummary;
import software.amazon.awssdk.services.mailmanager.model.SearchSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListArchiveSearchesResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, ListArchiveSearchesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListArchiveSearchesResponse.getter(ListArchiveSearchesResponse::nextToken)).setter(ListArchiveSearchesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<SearchSummary>> SEARCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Searches").getter(ListArchiveSearchesResponse.getter(ListArchiveSearchesResponse::searches)).setter(ListArchiveSearchesResponse.setter(Builder::searches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Searches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SEARCHES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Searches", SEARCHES_FIELD);
        }
    });
    private final String nextToken;
    private final List<SearchSummary> searches;

    private ListArchiveSearchesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.searches = builder.searches;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSearches() {
        return this.searches != null && !(this.searches instanceof SdkAutoConstructList);
    }

    public final List<SearchSummary> searches() {
        return this.searches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSearches() ? this.searches() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArchiveSearchesResponse)) {
            return false;
        }
        ListArchiveSearchesResponse other = (ListArchiveSearchesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSearches() == other.hasSearches() && Objects.equals(this.searches(), other.searches());
    }

    public final String toString() {
        return ToString.builder((String)"ListArchiveSearchesResponse").add("NextToken", (Object)this.nextToken()).add("Searches", this.hasSearches() ? this.searches() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Searches": {
                return Optional.ofNullable(clazz.cast(this.searches()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListArchiveSearchesResponse, T> g) {
        return obj -> g.apply((ListArchiveSearchesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SearchSummary> searches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListArchiveSearchesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.searches(model.searches);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SearchSummary.Builder> getSearches() {
            List<SearchSummary.Builder> result = SearchSummaryListCopier.copyToBuilder(this.searches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSearches(Collection<SearchSummary.BuilderImpl> searches) {
            this.searches = SearchSummaryListCopier.copyFromBuilder(searches);
        }

        @Override
        public final Builder searches(Collection<SearchSummary> searches) {
            this.searches = SearchSummaryListCopier.copy(searches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searches(SearchSummary ... searches) {
            this.searches(Arrays.asList(searches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searches(Consumer<SearchSummary.Builder> ... searches) {
            this.searches(Stream.of(searches).map(c -> (SearchSummary)((SearchSummary.Builder)SearchSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListArchiveSearchesResponse build() {
            return new ListArchiveSearchesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListArchiveSearchesResponse> {
        public Builder nextToken(String var1);

        public Builder searches(Collection<SearchSummary> var1);

        public Builder searches(SearchSummary ... var1);

        public Builder searches(Consumer<SearchSummary.Builder> ... var1);
    }
}

