/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mailmanager.model.RuleBooleanExpression;
import software.amazon.awssdk.services.mailmanager.model.RuleDmarcExpression;
import software.amazon.awssdk.services.mailmanager.model.RuleIpExpression;
import software.amazon.awssdk.services.mailmanager.model.RuleNumberExpression;
import software.amazon.awssdk.services.mailmanager.model.RuleStringExpression;
import software.amazon.awssdk.services.mailmanager.model.RuleVerdictExpression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleCondition> {
    private static final SdkField<RuleBooleanExpression> BOOLEAN_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BooleanExpression").getter(RuleCondition.getter(RuleCondition::booleanExpression)).setter(RuleCondition.setter(Builder::booleanExpression)).constructor(RuleBooleanExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanExpression").build()}).build();
    private static final SdkField<RuleDmarcExpression> DMARC_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DmarcExpression").getter(RuleCondition.getter(RuleCondition::dmarcExpression)).setter(RuleCondition.setter(Builder::dmarcExpression)).constructor(RuleDmarcExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DmarcExpression").build()}).build();
    private static final SdkField<RuleIpExpression> IP_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IpExpression").getter(RuleCondition.getter(RuleCondition::ipExpression)).setter(RuleCondition.setter(Builder::ipExpression)).constructor(RuleIpExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpExpression").build()}).build();
    private static final SdkField<RuleNumberExpression> NUMBER_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NumberExpression").getter(RuleCondition.getter(RuleCondition::numberExpression)).setter(RuleCondition.setter(Builder::numberExpression)).constructor(RuleNumberExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberExpression").build()}).build();
    private static final SdkField<RuleStringExpression> STRING_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StringExpression").getter(RuleCondition.getter(RuleCondition::stringExpression)).setter(RuleCondition.setter(Builder::stringExpression)).constructor(RuleStringExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringExpression").build()}).build();
    private static final SdkField<RuleVerdictExpression> VERDICT_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VerdictExpression").getter(RuleCondition.getter(RuleCondition::verdictExpression)).setter(RuleCondition.setter(Builder::verdictExpression)).constructor(RuleVerdictExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerdictExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_EXPRESSION_FIELD, DMARC_EXPRESSION_FIELD, IP_EXPRESSION_FIELD, NUMBER_EXPRESSION_FIELD, STRING_EXPRESSION_FIELD, VERDICT_EXPRESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BooleanExpression", BOOLEAN_EXPRESSION_FIELD);
            this.put("DmarcExpression", DMARC_EXPRESSION_FIELD);
            this.put("IpExpression", IP_EXPRESSION_FIELD);
            this.put("NumberExpression", NUMBER_EXPRESSION_FIELD);
            this.put("StringExpression", STRING_EXPRESSION_FIELD);
            this.put("VerdictExpression", VERDICT_EXPRESSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RuleBooleanExpression booleanExpression;
    private final RuleDmarcExpression dmarcExpression;
    private final RuleIpExpression ipExpression;
    private final RuleNumberExpression numberExpression;
    private final RuleStringExpression stringExpression;
    private final RuleVerdictExpression verdictExpression;
    private final Type type;

    private RuleCondition(BuilderImpl builder) {
        this.booleanExpression = builder.booleanExpression;
        this.dmarcExpression = builder.dmarcExpression;
        this.ipExpression = builder.ipExpression;
        this.numberExpression = builder.numberExpression;
        this.stringExpression = builder.stringExpression;
        this.verdictExpression = builder.verdictExpression;
        this.type = builder.type;
    }

    public final RuleBooleanExpression booleanExpression() {
        return this.booleanExpression;
    }

    public final RuleDmarcExpression dmarcExpression() {
        return this.dmarcExpression;
    }

    public final RuleIpExpression ipExpression() {
        return this.ipExpression;
    }

    public final RuleNumberExpression numberExpression() {
        return this.numberExpression;
    }

    public final RuleStringExpression stringExpression() {
        return this.stringExpression;
    }

    public final RuleVerdictExpression verdictExpression() {
        return this.verdictExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.dmarcExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.verdictExpression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleCondition)) {
            return false;
        }
        RuleCondition other = (RuleCondition)obj;
        return Objects.equals(this.booleanExpression(), other.booleanExpression()) && Objects.equals(this.dmarcExpression(), other.dmarcExpression()) && Objects.equals(this.ipExpression(), other.ipExpression()) && Objects.equals(this.numberExpression(), other.numberExpression()) && Objects.equals(this.stringExpression(), other.stringExpression()) && Objects.equals(this.verdictExpression(), other.verdictExpression());
    }

    public final String toString() {
        return ToString.builder((String)"RuleCondition").add("BooleanExpression", (Object)this.booleanExpression()).add("DmarcExpression", (Object)this.dmarcExpression()).add("IpExpression", (Object)this.ipExpression()).add("NumberExpression", (Object)this.numberExpression()).add("StringExpression", (Object)this.stringExpression()).add("VerdictExpression", (Object)this.verdictExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BooleanExpression": {
                return Optional.ofNullable(clazz.cast(this.booleanExpression()));
            }
            case "DmarcExpression": {
                return Optional.ofNullable(clazz.cast(this.dmarcExpression()));
            }
            case "IpExpression": {
                return Optional.ofNullable(clazz.cast(this.ipExpression()));
            }
            case "NumberExpression": {
                return Optional.ofNullable(clazz.cast(this.numberExpression()));
            }
            case "StringExpression": {
                return Optional.ofNullable(clazz.cast(this.stringExpression()));
            }
            case "VerdictExpression": {
                return Optional.ofNullable(clazz.cast(this.verdictExpression()));
            }
        }
        return Optional.empty();
    }

    public static RuleCondition fromBooleanExpression(RuleBooleanExpression booleanExpression) {
        return (RuleCondition)RuleCondition.builder().booleanExpression(booleanExpression).build();
    }

    public static RuleCondition fromBooleanExpression(Consumer<RuleBooleanExpression.Builder> booleanExpression) {
        RuleBooleanExpression.Builder builder = RuleBooleanExpression.builder();
        booleanExpression.accept(builder);
        return RuleCondition.fromBooleanExpression((RuleBooleanExpression)builder.build());
    }

    public static RuleCondition fromDmarcExpression(RuleDmarcExpression dmarcExpression) {
        return (RuleCondition)RuleCondition.builder().dmarcExpression(dmarcExpression).build();
    }

    public static RuleCondition fromDmarcExpression(Consumer<RuleDmarcExpression.Builder> dmarcExpression) {
        RuleDmarcExpression.Builder builder = RuleDmarcExpression.builder();
        dmarcExpression.accept(builder);
        return RuleCondition.fromDmarcExpression((RuleDmarcExpression)builder.build());
    }

    public static RuleCondition fromIpExpression(RuleIpExpression ipExpression) {
        return (RuleCondition)RuleCondition.builder().ipExpression(ipExpression).build();
    }

    public static RuleCondition fromIpExpression(Consumer<RuleIpExpression.Builder> ipExpression) {
        RuleIpExpression.Builder builder = RuleIpExpression.builder();
        ipExpression.accept(builder);
        return RuleCondition.fromIpExpression((RuleIpExpression)builder.build());
    }

    public static RuleCondition fromNumberExpression(RuleNumberExpression numberExpression) {
        return (RuleCondition)RuleCondition.builder().numberExpression(numberExpression).build();
    }

    public static RuleCondition fromNumberExpression(Consumer<RuleNumberExpression.Builder> numberExpression) {
        RuleNumberExpression.Builder builder = RuleNumberExpression.builder();
        numberExpression.accept(builder);
        return RuleCondition.fromNumberExpression((RuleNumberExpression)builder.build());
    }

    public static RuleCondition fromStringExpression(RuleStringExpression stringExpression) {
        return (RuleCondition)RuleCondition.builder().stringExpression(stringExpression).build();
    }

    public static RuleCondition fromStringExpression(Consumer<RuleStringExpression.Builder> stringExpression) {
        RuleStringExpression.Builder builder = RuleStringExpression.builder();
        stringExpression.accept(builder);
        return RuleCondition.fromStringExpression((RuleStringExpression)builder.build());
    }

    public static RuleCondition fromVerdictExpression(RuleVerdictExpression verdictExpression) {
        return (RuleCondition)RuleCondition.builder().verdictExpression(verdictExpression).build();
    }

    public static RuleCondition fromVerdictExpression(Consumer<RuleVerdictExpression.Builder> verdictExpression) {
        RuleVerdictExpression.Builder builder = RuleVerdictExpression.builder();
        verdictExpression.accept(builder);
        return RuleCondition.fromVerdictExpression((RuleVerdictExpression)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RuleCondition, T> g) {
        return obj -> g.apply((RuleCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BOOLEAN_EXPRESSION,
        DMARC_EXPRESSION,
        IP_EXPRESSION,
        NUMBER_EXPRESSION,
        STRING_EXPRESSION,
        VERDICT_EXPRESSION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private RuleBooleanExpression booleanExpression;
        private RuleDmarcExpression dmarcExpression;
        private RuleIpExpression ipExpression;
        private RuleNumberExpression numberExpression;
        private RuleStringExpression stringExpression;
        private RuleVerdictExpression verdictExpression;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleCondition model) {
            this.booleanExpression(model.booleanExpression);
            this.dmarcExpression(model.dmarcExpression);
            this.ipExpression(model.ipExpression);
            this.numberExpression(model.numberExpression);
            this.stringExpression(model.stringExpression);
            this.verdictExpression(model.verdictExpression);
        }

        public final RuleBooleanExpression.Builder getBooleanExpression() {
            return this.booleanExpression != null ? this.booleanExpression.toBuilder() : null;
        }

        public final void setBooleanExpression(RuleBooleanExpression.BuilderImpl booleanExpression) {
            RuleBooleanExpression oldValue = this.booleanExpression;
            this.booleanExpression = booleanExpression != null ? booleanExpression.build() : null;
            this.handleUnionValueChange(Type.BOOLEAN_EXPRESSION, oldValue, this.booleanExpression);
        }

        @Override
        public final Builder booleanExpression(RuleBooleanExpression booleanExpression) {
            RuleBooleanExpression oldValue = this.booleanExpression;
            this.booleanExpression = booleanExpression;
            this.handleUnionValueChange(Type.BOOLEAN_EXPRESSION, oldValue, this.booleanExpression);
            return this;
        }

        public final RuleDmarcExpression.Builder getDmarcExpression() {
            return this.dmarcExpression != null ? this.dmarcExpression.toBuilder() : null;
        }

        public final void setDmarcExpression(RuleDmarcExpression.BuilderImpl dmarcExpression) {
            RuleDmarcExpression oldValue = this.dmarcExpression;
            this.dmarcExpression = dmarcExpression != null ? dmarcExpression.build() : null;
            this.handleUnionValueChange(Type.DMARC_EXPRESSION, oldValue, this.dmarcExpression);
        }

        @Override
        public final Builder dmarcExpression(RuleDmarcExpression dmarcExpression) {
            RuleDmarcExpression oldValue = this.dmarcExpression;
            this.dmarcExpression = dmarcExpression;
            this.handleUnionValueChange(Type.DMARC_EXPRESSION, oldValue, this.dmarcExpression);
            return this;
        }

        public final RuleIpExpression.Builder getIpExpression() {
            return this.ipExpression != null ? this.ipExpression.toBuilder() : null;
        }

        public final void setIpExpression(RuleIpExpression.BuilderImpl ipExpression) {
            RuleIpExpression oldValue = this.ipExpression;
            this.ipExpression = ipExpression != null ? ipExpression.build() : null;
            this.handleUnionValueChange(Type.IP_EXPRESSION, oldValue, this.ipExpression);
        }

        @Override
        public final Builder ipExpression(RuleIpExpression ipExpression) {
            RuleIpExpression oldValue = this.ipExpression;
            this.ipExpression = ipExpression;
            this.handleUnionValueChange(Type.IP_EXPRESSION, oldValue, this.ipExpression);
            return this;
        }

        public final RuleNumberExpression.Builder getNumberExpression() {
            return this.numberExpression != null ? this.numberExpression.toBuilder() : null;
        }

        public final void setNumberExpression(RuleNumberExpression.BuilderImpl numberExpression) {
            RuleNumberExpression oldValue = this.numberExpression;
            this.numberExpression = numberExpression != null ? numberExpression.build() : null;
            this.handleUnionValueChange(Type.NUMBER_EXPRESSION, oldValue, this.numberExpression);
        }

        @Override
        public final Builder numberExpression(RuleNumberExpression numberExpression) {
            RuleNumberExpression oldValue = this.numberExpression;
            this.numberExpression = numberExpression;
            this.handleUnionValueChange(Type.NUMBER_EXPRESSION, oldValue, this.numberExpression);
            return this;
        }

        public final RuleStringExpression.Builder getStringExpression() {
            return this.stringExpression != null ? this.stringExpression.toBuilder() : null;
        }

        public final void setStringExpression(RuleStringExpression.BuilderImpl stringExpression) {
            RuleStringExpression oldValue = this.stringExpression;
            this.stringExpression = stringExpression != null ? stringExpression.build() : null;
            this.handleUnionValueChange(Type.STRING_EXPRESSION, oldValue, this.stringExpression);
        }

        @Override
        public final Builder stringExpression(RuleStringExpression stringExpression) {
            RuleStringExpression oldValue = this.stringExpression;
            this.stringExpression = stringExpression;
            this.handleUnionValueChange(Type.STRING_EXPRESSION, oldValue, this.stringExpression);
            return this;
        }

        public final RuleVerdictExpression.Builder getVerdictExpression() {
            return this.verdictExpression != null ? this.verdictExpression.toBuilder() : null;
        }

        public final void setVerdictExpression(RuleVerdictExpression.BuilderImpl verdictExpression) {
            RuleVerdictExpression oldValue = this.verdictExpression;
            this.verdictExpression = verdictExpression != null ? verdictExpression.build() : null;
            this.handleUnionValueChange(Type.VERDICT_EXPRESSION, oldValue, this.verdictExpression);
        }

        @Override
        public final Builder verdictExpression(RuleVerdictExpression verdictExpression) {
            RuleVerdictExpression oldValue = this.verdictExpression;
            this.verdictExpression = verdictExpression;
            this.handleUnionValueChange(Type.VERDICT_EXPRESSION, oldValue, this.verdictExpression);
            return this;
        }

        public RuleCondition build() {
            return new RuleCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleCondition> {
        public Builder booleanExpression(RuleBooleanExpression var1);

        default public Builder booleanExpression(Consumer<RuleBooleanExpression.Builder> booleanExpression) {
            return this.booleanExpression((RuleBooleanExpression)((RuleBooleanExpression.Builder)RuleBooleanExpression.builder().applyMutation(booleanExpression)).build());
        }

        public Builder dmarcExpression(RuleDmarcExpression var1);

        default public Builder dmarcExpression(Consumer<RuleDmarcExpression.Builder> dmarcExpression) {
            return this.dmarcExpression((RuleDmarcExpression)((RuleDmarcExpression.Builder)RuleDmarcExpression.builder().applyMutation(dmarcExpression)).build());
        }

        public Builder ipExpression(RuleIpExpression var1);

        default public Builder ipExpression(Consumer<RuleIpExpression.Builder> ipExpression) {
            return this.ipExpression((RuleIpExpression)((RuleIpExpression.Builder)RuleIpExpression.builder().applyMutation(ipExpression)).build());
        }

        public Builder numberExpression(RuleNumberExpression var1);

        default public Builder numberExpression(Consumer<RuleNumberExpression.Builder> numberExpression) {
            return this.numberExpression((RuleNumberExpression)((RuleNumberExpression.Builder)RuleNumberExpression.builder().applyMutation(numberExpression)).build());
        }

        public Builder stringExpression(RuleStringExpression var1);

        default public Builder stringExpression(Consumer<RuleStringExpression.Builder> stringExpression) {
            return this.stringExpression((RuleStringExpression)((RuleStringExpression.Builder)RuleStringExpression.builder().applyMutation(stringExpression)).build());
        }

        public Builder verdictExpression(RuleVerdictExpression var1);

        default public Builder verdictExpression(Consumer<RuleVerdictExpression.Builder> verdictExpression) {
            return this.verdictExpression((RuleVerdictExpression)((RuleVerdictExpression.Builder)RuleVerdictExpression.builder().applyMutation(verdictExpression)).build());
        }
    }
}

