/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mailmanager.model.ArchiveBooleanExpression;
import software.amazon.awssdk.services.mailmanager.model.ArchiveStringExpression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArchiveFilterCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArchiveFilterCondition> {
    private static final SdkField<ArchiveBooleanExpression> BOOLEAN_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BooleanExpression").getter(ArchiveFilterCondition.getter(ArchiveFilterCondition::booleanExpression)).setter(ArchiveFilterCondition.setter(Builder::booleanExpression)).constructor(ArchiveBooleanExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanExpression").build()}).build();
    private static final SdkField<ArchiveStringExpression> STRING_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StringExpression").getter(ArchiveFilterCondition.getter(ArchiveFilterCondition::stringExpression)).setter(ArchiveFilterCondition.setter(Builder::stringExpression)).constructor(ArchiveStringExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_EXPRESSION_FIELD, STRING_EXPRESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BooleanExpression", BOOLEAN_EXPRESSION_FIELD);
            this.put("StringExpression", STRING_EXPRESSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ArchiveBooleanExpression booleanExpression;
    private final ArchiveStringExpression stringExpression;
    private final Type type;

    private ArchiveFilterCondition(BuilderImpl builder) {
        this.booleanExpression = builder.booleanExpression;
        this.stringExpression = builder.stringExpression;
        this.type = builder.type;
    }

    public final ArchiveBooleanExpression booleanExpression() {
        return this.booleanExpression;
    }

    public final ArchiveStringExpression stringExpression() {
        return this.stringExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringExpression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveFilterCondition)) {
            return false;
        }
        ArchiveFilterCondition other = (ArchiveFilterCondition)obj;
        return Objects.equals(this.booleanExpression(), other.booleanExpression()) && Objects.equals(this.stringExpression(), other.stringExpression());
    }

    public final String toString() {
        return ToString.builder((String)"ArchiveFilterCondition").add("BooleanExpression", (Object)this.booleanExpression()).add("StringExpression", (Object)this.stringExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BooleanExpression": {
                return Optional.ofNullable(clazz.cast(this.booleanExpression()));
            }
            case "StringExpression": {
                return Optional.ofNullable(clazz.cast(this.stringExpression()));
            }
        }
        return Optional.empty();
    }

    public static ArchiveFilterCondition fromBooleanExpression(ArchiveBooleanExpression booleanExpression) {
        return (ArchiveFilterCondition)ArchiveFilterCondition.builder().booleanExpression(booleanExpression).build();
    }

    public static ArchiveFilterCondition fromBooleanExpression(Consumer<ArchiveBooleanExpression.Builder> booleanExpression) {
        ArchiveBooleanExpression.Builder builder = ArchiveBooleanExpression.builder();
        booleanExpression.accept(builder);
        return ArchiveFilterCondition.fromBooleanExpression((ArchiveBooleanExpression)builder.build());
    }

    public static ArchiveFilterCondition fromStringExpression(ArchiveStringExpression stringExpression) {
        return (ArchiveFilterCondition)ArchiveFilterCondition.builder().stringExpression(stringExpression).build();
    }

    public static ArchiveFilterCondition fromStringExpression(Consumer<ArchiveStringExpression.Builder> stringExpression) {
        ArchiveStringExpression.Builder builder = ArchiveStringExpression.builder();
        stringExpression.accept(builder);
        return ArchiveFilterCondition.fromStringExpression((ArchiveStringExpression)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ArchiveFilterCondition, T> g) {
        return obj -> g.apply((ArchiveFilterCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BOOLEAN_EXPRESSION,
        STRING_EXPRESSION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ArchiveBooleanExpression booleanExpression;
        private ArchiveStringExpression stringExpression;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveFilterCondition model) {
            this.booleanExpression(model.booleanExpression);
            this.stringExpression(model.stringExpression);
        }

        public final ArchiveBooleanExpression.Builder getBooleanExpression() {
            return this.booleanExpression != null ? this.booleanExpression.toBuilder() : null;
        }

        public final void setBooleanExpression(ArchiveBooleanExpression.BuilderImpl booleanExpression) {
            ArchiveBooleanExpression oldValue = this.booleanExpression;
            this.booleanExpression = booleanExpression != null ? booleanExpression.build() : null;
            this.handleUnionValueChange(Type.BOOLEAN_EXPRESSION, oldValue, this.booleanExpression);
        }

        @Override
        public final Builder booleanExpression(ArchiveBooleanExpression booleanExpression) {
            ArchiveBooleanExpression oldValue = this.booleanExpression;
            this.booleanExpression = booleanExpression;
            this.handleUnionValueChange(Type.BOOLEAN_EXPRESSION, oldValue, this.booleanExpression);
            return this;
        }

        public final ArchiveStringExpression.Builder getStringExpression() {
            return this.stringExpression != null ? this.stringExpression.toBuilder() : null;
        }

        public final void setStringExpression(ArchiveStringExpression.BuilderImpl stringExpression) {
            ArchiveStringExpression oldValue = this.stringExpression;
            this.stringExpression = stringExpression != null ? stringExpression.build() : null;
            this.handleUnionValueChange(Type.STRING_EXPRESSION, oldValue, this.stringExpression);
        }

        @Override
        public final Builder stringExpression(ArchiveStringExpression stringExpression) {
            ArchiveStringExpression oldValue = this.stringExpression;
            this.stringExpression = stringExpression;
            this.handleUnionValueChange(Type.STRING_EXPRESSION, oldValue, this.stringExpression);
            return this;
        }

        public ArchiveFilterCondition build() {
            return new ArchiveFilterCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArchiveFilterCondition> {
        public Builder booleanExpression(ArchiveBooleanExpression var1);

        default public Builder booleanExpression(Consumer<ArchiveBooleanExpression.Builder> booleanExpression) {
            return this.booleanExpression((ArchiveBooleanExpression)((ArchiveBooleanExpression.Builder)ArchiveBooleanExpression.builder().applyMutation(booleanExpression)).build());
        }

        public Builder stringExpression(ArchiveStringExpression var1);

        default public Builder stringExpression(Consumer<ArchiveStringExpression.Builder> stringExpression) {
            return this.stringExpression((ArchiveStringExpression)((ArchiveStringExpression.Builder)ArchiveStringExpression.builder().applyMutation(stringExpression)).build());
        }
    }
}

