/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.MailManagerRequest;
import software.amazon.awssdk.services.mailmanager.model.RelayAuthentication;
import software.amazon.awssdk.services.mailmanager.model.Tag;
import software.amazon.awssdk.services.mailmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRelayRequest
extends MailManagerRequest
implements ToCopyableBuilder<Builder, CreateRelayRequest> {
    private static final SdkField<RelayAuthentication> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Authentication").getter(CreateRelayRequest.getter(CreateRelayRequest::authentication)).setter(CreateRelayRequest.setter(Builder::authentication)).constructor(RelayAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateRelayRequest.getter(CreateRelayRequest::clientToken)).setter(CreateRelayRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> RELAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelayName").getter(CreateRelayRequest.getter(CreateRelayRequest::relayName)).setter(CreateRelayRequest.setter(Builder::relayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayName").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(CreateRelayRequest.getter(CreateRelayRequest::serverName)).setter(CreateRelayRequest.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> SERVER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ServerPort").getter(CreateRelayRequest.getter(CreateRelayRequest::serverPort)).setter(CreateRelayRequest.setter(Builder::serverPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPort").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateRelayRequest.getter(CreateRelayRequest::tags)).setter(CreateRelayRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_FIELD, CLIENT_TOKEN_FIELD, RELAY_NAME_FIELD, SERVER_NAME_FIELD, SERVER_PORT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Authentication", AUTHENTICATION_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("RelayName", RELAY_NAME_FIELD);
            this.put("ServerName", SERVER_NAME_FIELD);
            this.put("ServerPort", SERVER_PORT_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final RelayAuthentication authentication;
    private final String clientToken;
    private final String relayName;
    private final String serverName;
    private final Integer serverPort;
    private final List<Tag> tags;

    private CreateRelayRequest(BuilderImpl builder) {
        super(builder);
        this.authentication = builder.authentication;
        this.clientToken = builder.clientToken;
        this.relayName = builder.relayName;
        this.serverName = builder.serverName;
        this.serverPort = builder.serverPort;
        this.tags = builder.tags;
    }

    public final RelayAuthentication authentication() {
        return this.authentication;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String relayName() {
        return this.relayName;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final Integer serverPort() {
        return this.serverPort;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.relayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRelayRequest)) {
            return false;
        }
        CreateRelayRequest other = (CreateRelayRequest)((Object)obj);
        return Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.relayName(), other.relayName()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.serverPort(), other.serverPort()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRelayRequest").add("Authentication", (Object)this.authentication()).add("ClientToken", (Object)this.clientToken()).add("RelayName", (Object)this.relayName()).add("ServerName", (Object)this.serverName()).add("ServerPort", (Object)this.serverPort()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "RelayName": {
                return Optional.ofNullable(clazz.cast(this.relayName()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "ServerPort": {
                return Optional.ofNullable(clazz.cast(this.serverPort()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateRelayRequest, T> g) {
        return obj -> g.apply((CreateRelayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerRequest.BuilderImpl
    implements Builder {
        private RelayAuthentication authentication;
        private String clientToken;
        private String relayName;
        private String serverName;
        private Integer serverPort;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRelayRequest model) {
            super(model);
            this.authentication(model.authentication);
            this.clientToken(model.clientToken);
            this.relayName(model.relayName);
            this.serverName(model.serverName);
            this.serverPort(model.serverPort);
            this.tags(model.tags);
        }

        public final RelayAuthentication.Builder getAuthentication() {
            return this.authentication != null ? this.authentication.toBuilder() : null;
        }

        public final void setAuthentication(RelayAuthentication.BuilderImpl authentication) {
            this.authentication = authentication != null ? authentication.build() : null;
        }

        @Override
        public final Builder authentication(RelayAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRelayName() {
            return this.relayName;
        }

        public final void setRelayName(String relayName) {
            this.relayName = relayName;
        }

        @Override
        public final Builder relayName(String relayName) {
            this.relayName = relayName;
            return this;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getServerPort() {
            return this.serverPort;
        }

        public final void setServerPort(Integer serverPort) {
            this.serverPort = serverPort;
        }

        @Override
        public final Builder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRelayRequest build() {
            return new CreateRelayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MailManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRelayRequest> {
        public Builder authentication(RelayAuthentication var1);

        default public Builder authentication(Consumer<RelayAuthentication.Builder> authentication) {
            return this.authentication((RelayAuthentication)((RelayAuthentication.Builder)RelayAuthentication.builder().applyMutation(authentication)).build());
        }

        public Builder clientToken(String var1);

        public Builder relayName(String var1);

        public Builder serverName(String var1);

        public Builder serverPort(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

