/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.RuleAction;
import software.amazon.awssdk.services.mailmanager.model.RuleActionsCopier;
import software.amazon.awssdk.services.mailmanager.model.RuleCondition;
import software.amazon.awssdk.services.mailmanager.model.RuleConditionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Rule> {
    private static final SdkField<List<RuleAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(Rule.getter(Rule::actions)).setter(Rule.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RuleCondition>> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Conditions").getter(Rule.getter(Rule::conditions)).setter(Rule.setter(Builder::conditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Rule.getter(Rule::name)).setter(Rule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<RuleCondition>> UNLESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Unless").getter(Rule.getter(Rule::unless)).setter(Rule.setter(Builder::unless)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unless").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, CONDITIONS_FIELD, NAME_FIELD, UNLESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Actions", ACTIONS_FIELD);
            this.put("Conditions", CONDITIONS_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Unless", UNLESS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<RuleAction> actions;
    private final List<RuleCondition> conditions;
    private final String name;
    private final List<RuleCondition> unless;

    private Rule(BuilderImpl builder) {
        this.actions = builder.actions;
        this.conditions = builder.conditions;
        this.name = builder.name;
        this.unless = builder.unless;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<RuleAction> actions() {
        return this.actions;
    }

    public final boolean hasConditions() {
        return this.conditions != null && !(this.conditions instanceof SdkAutoConstructList);
    }

    public final List<RuleCondition> conditions() {
        return this.conditions;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasUnless() {
        return this.unless != null && !(this.unless instanceof SdkAutoConstructList);
    }

    public final List<RuleCondition> unless() {
        return this.unless;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditions() ? this.conditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnless() ? this.unless() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && this.hasConditions() == other.hasConditions() && Objects.equals(this.conditions(), other.conditions()) && Objects.equals(this.name(), other.name()) && this.hasUnless() == other.hasUnless() && Objects.equals(this.unless(), other.unless());
    }

    public final String toString() {
        return ToString.builder((String)"Rule").add("Actions", this.hasActions() ? this.actions() : null).add("Conditions", this.hasConditions() ? this.conditions() : null).add("Name", (Object)this.name()).add("Unless", this.hasUnless() ? this.unless() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "Conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Unless": {
                return Optional.ofNullable(clazz.cast(this.unless()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RuleAction> actions = DefaultSdkAutoConstructList.getInstance();
        private List<RuleCondition> conditions = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private List<RuleCondition> unless = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.actions(model.actions);
            this.conditions(model.conditions);
            this.name(model.name);
            this.unless(model.unless);
        }

        public final List<RuleAction.Builder> getActions() {
            List<RuleAction.Builder> result = RuleActionsCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<RuleAction.BuilderImpl> actions) {
            this.actions = RuleActionsCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<RuleAction> actions) {
            this.actions = RuleActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(RuleAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<RuleAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (RuleAction)((RuleAction.Builder)RuleAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RuleCondition.Builder> getConditions() {
            List<RuleCondition.Builder> result = RuleConditionsCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<RuleCondition.BuilderImpl> conditions) {
            this.conditions = RuleConditionsCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<RuleCondition> conditions) {
            this.conditions = RuleConditionsCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(RuleCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<RuleCondition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (RuleCondition)((RuleCondition.Builder)RuleCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<RuleCondition.Builder> getUnless() {
            List<RuleCondition.Builder> result = RuleConditionsCopier.copyToBuilder(this.unless);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnless(Collection<RuleCondition.BuilderImpl> unless) {
            this.unless = RuleConditionsCopier.copyFromBuilder(unless);
        }

        @Override
        public final Builder unless(Collection<RuleCondition> unless) {
            this.unless = RuleConditionsCopier.copy(unless);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unless(RuleCondition ... unless) {
            this.unless(Arrays.asList(unless));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unless(Consumer<RuleCondition.Builder> ... unless) {
            this.unless(Stream.of(unless).map(c -> (RuleCondition)((RuleCondition.Builder)RuleCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Rule build() {
            return new Rule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Rule> {
        public Builder actions(Collection<RuleAction> var1);

        public Builder actions(RuleAction ... var1);

        public Builder actions(Consumer<RuleAction.Builder> ... var1);

        public Builder conditions(Collection<RuleCondition> var1);

        public Builder conditions(RuleCondition ... var1);

        public Builder conditions(Consumer<RuleCondition.Builder> ... var1);

        public Builder name(String var1);

        public Builder unless(Collection<RuleCondition> var1);

        public Builder unless(RuleCondition ... var1);

        public Builder unless(Consumer<RuleCondition.Builder> ... var1);
    }
}

