/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerAsyncClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest;
import software.amazon.awssdk.services.mailmanager.model.ListRelaysResponse;
import software.amazon.awssdk.services.mailmanager.model.Relay;

public class ListRelaysPublisher
implements SdkPublisher<ListRelaysResponse> {
    private final MailManagerAsyncClient client;
    private final ListRelaysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRelaysPublisher(MailManagerAsyncClient client, ListRelaysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRelaysPublisher(MailManagerAsyncClient client, ListRelaysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRelaysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRelaysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Relay> relays() {
        Function<ListRelaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.relays() != null) {
                return response.relays().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRelaysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRelaysResponseFetcher
    implements AsyncPageFetcher<ListRelaysResponse> {
        private ListRelaysResponseFetcher() {
        }

        public boolean hasNextPage(ListRelaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRelaysResponse> nextPage(ListRelaysResponse previousPage) {
            if (previousPage == null) {
                return ListRelaysPublisher.this.client.listRelays(ListRelaysPublisher.this.firstRequest);
            }
            return ListRelaysPublisher.this.client.listRelays((ListRelaysRequest)((Object)ListRelaysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

