/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mailmanager.model.RetentionPeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArchiveRetention
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArchiveRetention> {
    private static final SdkField<String> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetentionPeriod").getter(ArchiveRetention.getter(ArchiveRetention::retentionPeriodAsString)).setter(ArchiveRetention.setter(Builder::retentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_PERIOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String retentionPeriod;
    private final Type type;

    private ArchiveRetention(BuilderImpl builder) {
        this.retentionPeriod = builder.retentionPeriod;
        this.type = builder.type;
    }

    public final RetentionPeriod retentionPeriod() {
        return RetentionPeriod.fromValue(this.retentionPeriod);
    }

    public final String retentionPeriodAsString() {
        return this.retentionPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveRetention)) {
            return false;
        }
        ArchiveRetention other = (ArchiveRetention)obj;
        return Objects.equals(this.retentionPeriodAsString(), other.retentionPeriodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ArchiveRetention").add("RetentionPeriod", (Object)this.retentionPeriodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriodAsString()));
            }
        }
        return Optional.empty();
    }

    public static ArchiveRetention fromRetentionPeriod(String retentionPeriod) {
        return (ArchiveRetention)ArchiveRetention.builder().retentionPeriod(retentionPeriod).build();
    }

    public static ArchiveRetention fromRetentionPeriod(RetentionPeriod retentionPeriod) {
        return (ArchiveRetention)ArchiveRetention.builder().retentionPeriod(retentionPeriod).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArchiveRetention, T> g) {
        return obj -> g.apply((ArchiveRetention)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        RETENTION_PERIOD,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String retentionPeriod;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveRetention model) {
            this.retentionPeriod(model.retentionPeriod);
        }

        public final String getRetentionPeriod() {
            return this.retentionPeriod;
        }

        public final void setRetentionPeriod(String retentionPeriod) {
            String oldValue = this.retentionPeriod;
            this.retentionPeriod = retentionPeriod;
            this.handleUnionValueChange(Type.RETENTION_PERIOD, oldValue, this.retentionPeriod);
        }

        @Override
        public final Builder retentionPeriod(String retentionPeriod) {
            String oldValue = this.retentionPeriod;
            this.retentionPeriod = retentionPeriod;
            this.handleUnionValueChange(Type.RETENTION_PERIOD, oldValue, this.retentionPeriod);
            return this;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod(retentionPeriod == null ? null : retentionPeriod.toString());
            return this;
        }

        public ArchiveRetention build() {
            return new ArchiveRetention(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArchiveRetention> {
        public Builder retentionPeriod(String var1);

        public Builder retentionPeriod(RetentionPeriod var1);
    }
}

