/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.services.mailmanager.model.Rule;
import software.amazon.awssdk.services.mailmanager.model.RulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRuleSetResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, GetRuleSetResponse> {
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(GetRuleSetResponse.getter(GetRuleSetResponse::createdDate)).setter(GetRuleSetResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationDate").getter(GetRuleSetResponse.getter(GetRuleSetResponse::lastModificationDate)).setter(GetRuleSetResponse.setter(Builder::lastModificationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationDate").build()}).build();
    private static final SdkField<String> RULE_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleSetArn").getter(GetRuleSetResponse.getter(GetRuleSetResponse::ruleSetArn)).setter(GetRuleSetResponse.setter(Builder::ruleSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetArn").build()}).build();
    private static final SdkField<String> RULE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleSetId").getter(GetRuleSetResponse.getter(GetRuleSetResponse::ruleSetId)).setter(GetRuleSetResponse.setter(Builder::ruleSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetId").build()}).build();
    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleSetName").getter(GetRuleSetResponse.getter(GetRuleSetResponse::ruleSetName)).setter(GetRuleSetResponse.setter(Builder::ruleSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()}).build();
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(GetRuleSetResponse.getter(GetRuleSetResponse::rules)).setter(GetRuleSetResponse.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_DATE_FIELD, LAST_MODIFICATION_DATE_FIELD, RULE_SET_ARN_FIELD, RULE_SET_ID_FIELD, RULE_SET_NAME_FIELD, RULES_FIELD));
    private final Instant createdDate;
    private final Instant lastModificationDate;
    private final String ruleSetArn;
    private final String ruleSetId;
    private final String ruleSetName;
    private final List<Rule> rules;

    private GetRuleSetResponse(BuilderImpl builder) {
        super(builder);
        this.createdDate = builder.createdDate;
        this.lastModificationDate = builder.lastModificationDate;
        this.ruleSetArn = builder.ruleSetArn;
        this.ruleSetId = builder.ruleSetId;
        this.ruleSetName = builder.ruleSetName;
        this.rules = builder.rules;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant lastModificationDate() {
        return this.lastModificationDate;
    }

    public final String ruleSetArn() {
        return this.ruleSetArn;
    }

    public final String ruleSetId() {
        return this.ruleSetId;
    }

    public final String ruleSetName() {
        return this.ruleSetName;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<Rule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRuleSetResponse)) {
            return false;
        }
        GetRuleSetResponse other = (GetRuleSetResponse)((Object)obj);
        return Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastModificationDate(), other.lastModificationDate()) && Objects.equals(this.ruleSetArn(), other.ruleSetArn()) && Objects.equals(this.ruleSetId(), other.ruleSetId()) && Objects.equals(this.ruleSetName(), other.ruleSetName()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules());
    }

    public final String toString() {
        return ToString.builder((String)"GetRuleSetResponse").add("CreatedDate", (Object)this.createdDate()).add("LastModificationDate", (Object)this.lastModificationDate()).add("RuleSetArn", (Object)this.ruleSetArn()).add("RuleSetId", (Object)this.ruleSetId()).add("RuleSetName", (Object)this.ruleSetName()).add("Rules", this.hasRules() ? this.rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "LastModificationDate": {
                return Optional.ofNullable(clazz.cast(this.lastModificationDate()));
            }
            case "RuleSetArn": {
                return Optional.ofNullable(clazz.cast(this.ruleSetArn()));
            }
            case "RuleSetId": {
                return Optional.ofNullable(clazz.cast(this.ruleSetId()));
            }
            case "RuleSetName": {
                return Optional.ofNullable(clazz.cast(this.ruleSetName()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRuleSetResponse, T> g) {
        return obj -> g.apply((GetRuleSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private Instant createdDate;
        private Instant lastModificationDate;
        private String ruleSetArn;
        private String ruleSetId;
        private String ruleSetName;
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRuleSetResponse model) {
            super(model);
            this.createdDate(model.createdDate);
            this.lastModificationDate(model.lastModificationDate);
            this.ruleSetArn(model.ruleSetArn);
            this.ruleSetId(model.ruleSetId);
            this.ruleSetName(model.ruleSetName);
            this.rules(model.rules);
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastModificationDate() {
            return this.lastModificationDate;
        }

        public final void setLastModificationDate(Instant lastModificationDate) {
            this.lastModificationDate = lastModificationDate;
        }

        @Override
        public final Builder lastModificationDate(Instant lastModificationDate) {
            this.lastModificationDate = lastModificationDate;
            return this;
        }

        public final String getRuleSetArn() {
            return this.ruleSetArn;
        }

        public final void setRuleSetArn(String ruleSetArn) {
            this.ruleSetArn = ruleSetArn;
        }

        @Override
        public final Builder ruleSetArn(String ruleSetArn) {
            this.ruleSetArn = ruleSetArn;
            return this;
        }

        public final String getRuleSetId() {
            return this.ruleSetId;
        }

        public final void setRuleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
        }

        @Override
        public final Builder ruleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RulesCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRuleSetResponse build() {
            return new GetRuleSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRuleSetResponse> {
        public Builder createdDate(Instant var1);

        public Builder lastModificationDate(Instant var1);

        public Builder ruleSetArn(String var1);

        public Builder ruleSetId(String var1);

        public Builder ruleSetName(String var1);

        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);
    }
}

