/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.JobStatus;
import software.amazon.awssdk.services.macie2.model.JobType;
import software.amazon.awssdk.services.macie2.model.LastRunErrorStatus;
import software.amazon.awssdk.services.macie2.model.S3BucketCriteriaForJob;
import software.amazon.awssdk.services.macie2.model.S3BucketDefinitionForJob;
import software.amazon.awssdk.services.macie2.model.UserPausedDetails;
import software.amazon.awssdk.services.macie2.model.___listOfS3BucketDefinitionForJobCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobSummary> {
    private static final SdkField<S3BucketCriteriaForJob> BUCKET_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bucketCriteria").getter(JobSummary.getter(JobSummary::bucketCriteria)).setter(JobSummary.setter(Builder::bucketCriteria)).constructor(S3BucketCriteriaForJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCriteria").build()}).build();
    private static final SdkField<List<S3BucketDefinitionForJob>> BUCKET_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bucketDefinitions").getter(JobSummary.getter(JobSummary::bucketDefinitions)).setter(JobSummary.setter(Builder::bucketDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3BucketDefinitionForJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(JobSummary.getter(JobSummary::createdAt)).setter(JobSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(JobSummary.getter(JobSummary::jobId)).setter(JobSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobStatus").getter(JobSummary.getter(JobSummary::jobStatusAsString)).setter(JobSummary.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobType").getter(JobSummary.getter(JobSummary::jobTypeAsString)).setter(JobSummary.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()}).build();
    private static final SdkField<LastRunErrorStatus> LAST_RUN_ERROR_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lastRunErrorStatus").getter(JobSummary.getter(JobSummary::lastRunErrorStatus)).setter(JobSummary.setter(Builder::lastRunErrorStatus)).constructor(LastRunErrorStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunErrorStatus").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(JobSummary.getter(JobSummary::name)).setter(JobSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<UserPausedDetails> USER_PAUSED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userPausedDetails").getter(JobSummary.getter(JobSummary::userPausedDetails)).setter(JobSummary.setter(Builder::userPausedDetails)).constructor(UserPausedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPausedDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_CRITERIA_FIELD, BUCKET_DEFINITIONS_FIELD, CREATED_AT_FIELD, JOB_ID_FIELD, JOB_STATUS_FIELD, JOB_TYPE_FIELD, LAST_RUN_ERROR_STATUS_FIELD, NAME_FIELD, USER_PAUSED_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3BucketCriteriaForJob bucketCriteria;
    private final List<S3BucketDefinitionForJob> bucketDefinitions;
    private final Instant createdAt;
    private final String jobId;
    private final String jobStatus;
    private final String jobType;
    private final LastRunErrorStatus lastRunErrorStatus;
    private final String name;
    private final UserPausedDetails userPausedDetails;

    private JobSummary(BuilderImpl builder) {
        this.bucketCriteria = builder.bucketCriteria;
        this.bucketDefinitions = builder.bucketDefinitions;
        this.createdAt = builder.createdAt;
        this.jobId = builder.jobId;
        this.jobStatus = builder.jobStatus;
        this.jobType = builder.jobType;
        this.lastRunErrorStatus = builder.lastRunErrorStatus;
        this.name = builder.name;
        this.userPausedDetails = builder.userPausedDetails;
    }

    public final S3BucketCriteriaForJob bucketCriteria() {
        return this.bucketCriteria;
    }

    public final boolean hasBucketDefinitions() {
        return this.bucketDefinitions != null && !(this.bucketDefinitions instanceof SdkAutoConstructList);
    }

    public final List<S3BucketDefinitionForJob> bucketDefinitions() {
        return this.bucketDefinitions;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final LastRunErrorStatus lastRunErrorStatus() {
        return this.lastRunErrorStatus;
    }

    public final String name() {
        return this.name;
    }

    public final UserPausedDetails userPausedDetails() {
        return this.userPausedDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBucketDefinitions() ? this.bucketDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunErrorStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPausedDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSummary)) {
            return false;
        }
        JobSummary other = (JobSummary)obj;
        return Objects.equals(this.bucketCriteria(), other.bucketCriteria()) && this.hasBucketDefinitions() == other.hasBucketDefinitions() && Objects.equals(this.bucketDefinitions(), other.bucketDefinitions()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.lastRunErrorStatus(), other.lastRunErrorStatus()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.userPausedDetails(), other.userPausedDetails());
    }

    public final String toString() {
        return ToString.builder((String)"JobSummary").add("BucketCriteria", (Object)this.bucketCriteria()).add("BucketDefinitions", this.hasBucketDefinitions() ? this.bucketDefinitions() : null).add("CreatedAt", (Object)this.createdAt()).add("JobId", (Object)this.jobId()).add("JobStatus", (Object)this.jobStatusAsString()).add("JobType", (Object)this.jobTypeAsString()).add("LastRunErrorStatus", (Object)this.lastRunErrorStatus()).add("Name", (Object)this.name()).add("UserPausedDetails", (Object)this.userPausedDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketCriteria": {
                return Optional.ofNullable(clazz.cast(this.bucketCriteria()));
            }
            case "bucketDefinitions": {
                return Optional.ofNullable(clazz.cast(this.bucketDefinitions()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "jobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "lastRunErrorStatus": {
                return Optional.ofNullable(clazz.cast(this.lastRunErrorStatus()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "userPausedDetails": {
                return Optional.ofNullable(clazz.cast(this.userPausedDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bucketCriteria", BUCKET_CRITERIA_FIELD);
        map.put("bucketDefinitions", BUCKET_DEFINITIONS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("jobStatus", JOB_STATUS_FIELD);
        map.put("jobType", JOB_TYPE_FIELD);
        map.put("lastRunErrorStatus", LAST_RUN_ERROR_STATUS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("userPausedDetails", USER_PAUSED_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobSummary, T> g) {
        return obj -> g.apply((JobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3BucketCriteriaForJob bucketCriteria;
        private List<S3BucketDefinitionForJob> bucketDefinitions = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private String jobId;
        private String jobStatus;
        private String jobType;
        private LastRunErrorStatus lastRunErrorStatus;
        private String name;
        private UserPausedDetails userPausedDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSummary model) {
            this.bucketCriteria(model.bucketCriteria);
            this.bucketDefinitions(model.bucketDefinitions);
            this.createdAt(model.createdAt);
            this.jobId(model.jobId);
            this.jobStatus(model.jobStatus);
            this.jobType(model.jobType);
            this.lastRunErrorStatus(model.lastRunErrorStatus);
            this.name(model.name);
            this.userPausedDetails(model.userPausedDetails);
        }

        public final S3BucketCriteriaForJob.Builder getBucketCriteria() {
            return this.bucketCriteria != null ? this.bucketCriteria.toBuilder() : null;
        }

        public final void setBucketCriteria(S3BucketCriteriaForJob.BuilderImpl bucketCriteria) {
            this.bucketCriteria = bucketCriteria != null ? bucketCriteria.build() : null;
        }

        @Override
        public final Builder bucketCriteria(S3BucketCriteriaForJob bucketCriteria) {
            this.bucketCriteria = bucketCriteria;
            return this;
        }

        public final List<S3BucketDefinitionForJob.Builder> getBucketDefinitions() {
            List<S3BucketDefinitionForJob.Builder> result = ___listOfS3BucketDefinitionForJobCopier.copyToBuilder(this.bucketDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBucketDefinitions(Collection<S3BucketDefinitionForJob.BuilderImpl> bucketDefinitions) {
            this.bucketDefinitions = ___listOfS3BucketDefinitionForJobCopier.copyFromBuilder(bucketDefinitions);
        }

        @Override
        public final Builder bucketDefinitions(Collection<S3BucketDefinitionForJob> bucketDefinitions) {
            this.bucketDefinitions = ___listOfS3BucketDefinitionForJobCopier.copy(bucketDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketDefinitions(S3BucketDefinitionForJob ... bucketDefinitions) {
            this.bucketDefinitions(Arrays.asList(bucketDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketDefinitions(Consumer<S3BucketDefinitionForJob.Builder> ... bucketDefinitions) {
            this.bucketDefinitions(Stream.of(bucketDefinitions).map(c -> (S3BucketDefinitionForJob)((S3BucketDefinitionForJob.Builder)S3BucketDefinitionForJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final LastRunErrorStatus.Builder getLastRunErrorStatus() {
            return this.lastRunErrorStatus != null ? this.lastRunErrorStatus.toBuilder() : null;
        }

        public final void setLastRunErrorStatus(LastRunErrorStatus.BuilderImpl lastRunErrorStatus) {
            this.lastRunErrorStatus = lastRunErrorStatus != null ? lastRunErrorStatus.build() : null;
        }

        @Override
        public final Builder lastRunErrorStatus(LastRunErrorStatus lastRunErrorStatus) {
            this.lastRunErrorStatus = lastRunErrorStatus;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final UserPausedDetails.Builder getUserPausedDetails() {
            return this.userPausedDetails != null ? this.userPausedDetails.toBuilder() : null;
        }

        public final void setUserPausedDetails(UserPausedDetails.BuilderImpl userPausedDetails) {
            this.userPausedDetails = userPausedDetails != null ? userPausedDetails.build() : null;
        }

        @Override
        public final Builder userPausedDetails(UserPausedDetails userPausedDetails) {
            this.userPausedDetails = userPausedDetails;
            return this;
        }

        public JobSummary build() {
            return new JobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobSummary> {
        public Builder bucketCriteria(S3BucketCriteriaForJob var1);

        default public Builder bucketCriteria(Consumer<S3BucketCriteriaForJob.Builder> bucketCriteria) {
            return this.bucketCriteria((S3BucketCriteriaForJob)((S3BucketCriteriaForJob.Builder)S3BucketCriteriaForJob.builder().applyMutation(bucketCriteria)).build());
        }

        public Builder bucketDefinitions(Collection<S3BucketDefinitionForJob> var1);

        public Builder bucketDefinitions(S3BucketDefinitionForJob ... var1);

        public Builder bucketDefinitions(Consumer<S3BucketDefinitionForJob.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder jobId(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder lastRunErrorStatus(LastRunErrorStatus var1);

        default public Builder lastRunErrorStatus(Consumer<LastRunErrorStatus.Builder> lastRunErrorStatus) {
            return this.lastRunErrorStatus((LastRunErrorStatus)((LastRunErrorStatus.Builder)LastRunErrorStatus.builder().applyMutation(lastRunErrorStatus)).build());
        }

        public Builder name(String var1);

        public Builder userPausedDetails(UserPausedDetails var1);

        default public Builder userPausedDetails(Consumer<UserPausedDetails.Builder> userPausedDetails) {
            return this.userPausedDetails((UserPausedDetails)((UserPausedDetails.Builder)UserPausedDetails.builder().applyMutation(userPausedDetails)).build());
        }
    }
}

