/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.IsDefinedInJob;
import software.amazon.awssdk.services.macie2.model.IsMonitoredByJob;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobDetails> {
    private static final SdkField<String> IS_DEFINED_IN_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("isDefinedInJob").getter(JobDetails.getter(JobDetails::isDefinedInJobAsString)).setter(JobDetails.setter(Builder::isDefinedInJob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDefinedInJob").build()}).build();
    private static final SdkField<String> IS_MONITORED_BY_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("isMonitoredByJob").getter(JobDetails.getter(JobDetails::isMonitoredByJobAsString)).setter(JobDetails.setter(Builder::isMonitoredByJob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isMonitoredByJob").build()}).build();
    private static final SdkField<String> LAST_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastJobId").getter(JobDetails.getter(JobDetails::lastJobId)).setter(JobDetails.setter(Builder::lastJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastJobId").build()}).build();
    private static final SdkField<Instant> LAST_JOB_RUN_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastJobRunTime").getter(JobDetails.getter(JobDetails::lastJobRunTime)).setter(JobDetails.setter(Builder::lastJobRunTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastJobRunTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_DEFINED_IN_JOB_FIELD, IS_MONITORED_BY_JOB_FIELD, LAST_JOB_ID_FIELD, LAST_JOB_RUN_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String isDefinedInJob;
    private final String isMonitoredByJob;
    private final String lastJobId;
    private final Instant lastJobRunTime;

    private JobDetails(BuilderImpl builder) {
        this.isDefinedInJob = builder.isDefinedInJob;
        this.isMonitoredByJob = builder.isMonitoredByJob;
        this.lastJobId = builder.lastJobId;
        this.lastJobRunTime = builder.lastJobRunTime;
    }

    public final IsDefinedInJob isDefinedInJob() {
        return IsDefinedInJob.fromValue(this.isDefinedInJob);
    }

    public final String isDefinedInJobAsString() {
        return this.isDefinedInJob;
    }

    public final IsMonitoredByJob isMonitoredByJob() {
        return IsMonitoredByJob.fromValue(this.isMonitoredByJob);
    }

    public final String isMonitoredByJobAsString() {
        return this.isMonitoredByJob;
    }

    public final String lastJobId() {
        return this.lastJobId;
    }

    public final Instant lastJobRunTime() {
        return this.lastJobRunTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefinedInJobAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isMonitoredByJobAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastJobRunTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetails)) {
            return false;
        }
        JobDetails other = (JobDetails)obj;
        return Objects.equals(this.isDefinedInJobAsString(), other.isDefinedInJobAsString()) && Objects.equals(this.isMonitoredByJobAsString(), other.isMonitoredByJobAsString()) && Objects.equals(this.lastJobId(), other.lastJobId()) && Objects.equals(this.lastJobRunTime(), other.lastJobRunTime());
    }

    public final String toString() {
        return ToString.builder((String)"JobDetails").add("IsDefinedInJob", (Object)this.isDefinedInJobAsString()).add("IsMonitoredByJob", (Object)this.isMonitoredByJobAsString()).add("LastJobId", (Object)this.lastJobId()).add("LastJobRunTime", (Object)this.lastJobRunTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isDefinedInJob": {
                return Optional.ofNullable(clazz.cast(this.isDefinedInJobAsString()));
            }
            case "isMonitoredByJob": {
                return Optional.ofNullable(clazz.cast(this.isMonitoredByJobAsString()));
            }
            case "lastJobId": {
                return Optional.ofNullable(clazz.cast(this.lastJobId()));
            }
            case "lastJobRunTime": {
                return Optional.ofNullable(clazz.cast(this.lastJobRunTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isDefinedInJob", IS_DEFINED_IN_JOB_FIELD);
        map.put("isMonitoredByJob", IS_MONITORED_BY_JOB_FIELD);
        map.put("lastJobId", LAST_JOB_ID_FIELD);
        map.put("lastJobRunTime", LAST_JOB_RUN_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobDetails, T> g) {
        return obj -> g.apply((JobDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String isDefinedInJob;
        private String isMonitoredByJob;
        private String lastJobId;
        private Instant lastJobRunTime;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetails model) {
            this.isDefinedInJob(model.isDefinedInJob);
            this.isMonitoredByJob(model.isMonitoredByJob);
            this.lastJobId(model.lastJobId);
            this.lastJobRunTime(model.lastJobRunTime);
        }

        public final String getIsDefinedInJob() {
            return this.isDefinedInJob;
        }

        public final void setIsDefinedInJob(String isDefinedInJob) {
            this.isDefinedInJob = isDefinedInJob;
        }

        @Override
        public final Builder isDefinedInJob(String isDefinedInJob) {
            this.isDefinedInJob = isDefinedInJob;
            return this;
        }

        @Override
        public final Builder isDefinedInJob(IsDefinedInJob isDefinedInJob) {
            this.isDefinedInJob(isDefinedInJob == null ? null : isDefinedInJob.toString());
            return this;
        }

        public final String getIsMonitoredByJob() {
            return this.isMonitoredByJob;
        }

        public final void setIsMonitoredByJob(String isMonitoredByJob) {
            this.isMonitoredByJob = isMonitoredByJob;
        }

        @Override
        public final Builder isMonitoredByJob(String isMonitoredByJob) {
            this.isMonitoredByJob = isMonitoredByJob;
            return this;
        }

        @Override
        public final Builder isMonitoredByJob(IsMonitoredByJob isMonitoredByJob) {
            this.isMonitoredByJob(isMonitoredByJob == null ? null : isMonitoredByJob.toString());
            return this;
        }

        public final String getLastJobId() {
            return this.lastJobId;
        }

        public final void setLastJobId(String lastJobId) {
            this.lastJobId = lastJobId;
        }

        @Override
        public final Builder lastJobId(String lastJobId) {
            this.lastJobId = lastJobId;
            return this;
        }

        public final Instant getLastJobRunTime() {
            return this.lastJobRunTime;
        }

        public final void setLastJobRunTime(Instant lastJobRunTime) {
            this.lastJobRunTime = lastJobRunTime;
        }

        @Override
        public final Builder lastJobRunTime(Instant lastJobRunTime) {
            this.lastJobRunTime = lastJobRunTime;
            return this;
        }

        public JobDetails build() {
            return new JobDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobDetails> {
        public Builder isDefinedInJob(String var1);

        public Builder isDefinedInJob(IsDefinedInJob var1);

        public Builder isMonitoredByJob(String var1);

        public Builder isMonitoredByJob(IsMonitoredByJob var1);

        public Builder lastJobId(String var1);

        public Builder lastJobRunTime(Instant var1);
    }
}

