/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.AvailabilityCode;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode;
import software.amazon.awssdk.services.macie2.model.___listOfUnavailabilityReasonCodeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSensitiveDataOccurrencesAvailabilityResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, GetSensitiveDataOccurrencesAvailabilityResponse> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(GetSensitiveDataOccurrencesAvailabilityResponse.getter(GetSensitiveDataOccurrencesAvailabilityResponse::codeAsString)).setter(GetSensitiveDataOccurrencesAvailabilityResponse.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<List<String>> REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reasons").getter(GetSensitiveDataOccurrencesAvailabilityResponse.getter(GetSensitiveDataOccurrencesAvailabilityResponse::reasonsAsStrings)).setter(GetSensitiveDataOccurrencesAvailabilityResponse.setter(Builder::reasonsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSensitiveDataOccurrencesAvailabilityResponse.memberNameToFieldInitializer();
    private final String code;
    private final List<String> reasons;

    private GetSensitiveDataOccurrencesAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.code = builder.code;
        this.reasons = builder.reasons;
    }

    public final AvailabilityCode code() {
        return AvailabilityCode.fromValue(this.code);
    }

    public final String codeAsString() {
        return this.code;
    }

    public final List<UnavailabilityReasonCode> reasons() {
        return ___listOfUnavailabilityReasonCodeCopier.copyStringToEnum(this.reasons);
    }

    public final boolean hasReasons() {
        return this.reasons != null && !(this.reasons instanceof SdkAutoConstructList);
    }

    public final List<String> reasonsAsStrings() {
        return this.reasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReasons() ? this.reasonsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSensitiveDataOccurrencesAvailabilityResponse)) {
            return false;
        }
        GetSensitiveDataOccurrencesAvailabilityResponse other = (GetSensitiveDataOccurrencesAvailabilityResponse)((Object)obj);
        return Objects.equals(this.codeAsString(), other.codeAsString()) && this.hasReasons() == other.hasReasons() && Objects.equals(this.reasonsAsStrings(), other.reasonsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetSensitiveDataOccurrencesAvailabilityResponse").add("Code", (Object)this.codeAsString()).add("Reasons", this.hasReasons() ? this.reasonsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
            case "reasons": {
                return Optional.ofNullable(clazz.cast(this.reasonsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", CODE_FIELD);
        map.put("reasons", REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSensitiveDataOccurrencesAvailabilityResponse, T> g) {
        return obj -> g.apply((GetSensitiveDataOccurrencesAvailabilityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private String code;
        private List<String> reasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSensitiveDataOccurrencesAvailabilityResponse model) {
            super(model);
            this.code(model.code);
            this.reasonsWithStrings(model.reasons);
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(AvailabilityCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final Collection<String> getReasons() {
            if (this.reasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reasons;
        }

        public final void setReasons(Collection<String> reasons) {
            this.reasons = ___listOfUnavailabilityReasonCodeCopier.copy(reasons);
        }

        @Override
        public final Builder reasonsWithStrings(Collection<String> reasons) {
            this.reasons = ___listOfUnavailabilityReasonCodeCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonsWithStrings(String ... reasons) {
            this.reasonsWithStrings(Arrays.asList(reasons));
            return this;
        }

        @Override
        public final Builder reasons(Collection<UnavailabilityReasonCode> reasons) {
            this.reasons = ___listOfUnavailabilityReasonCodeCopier.copyEnumToString(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(UnavailabilityReasonCode ... reasons) {
            this.reasons(Arrays.asList(reasons));
            return this;
        }

        @Override
        public GetSensitiveDataOccurrencesAvailabilityResponse build() {
            return new GetSensitiveDataOccurrencesAvailabilityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSensitiveDataOccurrencesAvailabilityResponse> {
        public Builder code(String var1);

        public Builder code(AvailabilityCode var1);

        public Builder reasonsWithStrings(Collection<String> var1);

        public Builder reasonsWithStrings(String ... var1);

        public Builder reasons(Collection<UnavailabilityReasonCode> var1);

        public Builder reasons(UnavailabilityReasonCode ... var1);
    }
}

