/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.SeverityDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Severity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Severity> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Severity.getter(Severity::descriptionAsString)).setter(Severity.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Long> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("score").getter(Severity.getter(Severity::score)).setter(Severity.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, SCORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Severity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final Long score;

    private Severity(BuilderImpl builder) {
        this.description = builder.description;
        this.score = builder.score;
    }

    public final SeverityDescription description() {
        return SeverityDescription.fromValue(this.description);
    }

    public final String descriptionAsString() {
        return this.description;
    }

    public final Long score() {
        return this.score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.descriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Severity)) {
            return false;
        }
        Severity other = (Severity)obj;
        return Objects.equals(this.descriptionAsString(), other.descriptionAsString()) && Objects.equals(this.score(), other.score());
    }

    public final String toString() {
        return ToString.builder((String)"Severity").add("Description", (Object)this.descriptionAsString()).add("Score", (Object)this.score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.descriptionAsString()));
            }
            case "score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("score", SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Severity, T> g) {
        return obj -> g.apply((Severity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private Long score;

        private BuilderImpl() {
        }

        private BuilderImpl(Severity model) {
            this.description(model.description);
            this.score(model.score);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public final Builder description(SeverityDescription description) {
            this.description(description == null ? null : description.toString());
            return this;
        }

        public final Long getScore() {
            return this.score;
        }

        public final void setScore(Long score) {
            this.score = score;
        }

        @Override
        public final Builder score(Long score) {
            this.score = score;
            return this;
        }

        public Severity build() {
            return new Severity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Severity> {
        public Builder description(String var1);

        public Builder description(SeverityDescription var1);

        public Builder score(Long var1);
    }
}

