/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Record
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Record> {
    private static final SdkField<String> JSON_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jsonPath").getter(Record.getter(Record::jsonPath)).setter(Record.setter(Builder::jsonPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonPath").build()}).build();
    private static final SdkField<Long> RECORD_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("recordIndex").getter(Record.getter(Record::recordIndex)).setter(Record.setter(Builder::recordIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_PATH_FIELD, RECORD_INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Record.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jsonPath;
    private final Long recordIndex;

    private Record(BuilderImpl builder) {
        this.jsonPath = builder.jsonPath;
        this.recordIndex = builder.recordIndex;
    }

    public final String jsonPath() {
        return this.jsonPath;
    }

    public final Long recordIndex() {
        return this.recordIndex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordIndex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        return Objects.equals(this.jsonPath(), other.jsonPath()) && Objects.equals(this.recordIndex(), other.recordIndex());
    }

    public final String toString() {
        return ToString.builder((String)"Record").add("JsonPath", (Object)this.jsonPath()).add("RecordIndex", (Object)this.recordIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jsonPath": {
                return Optional.ofNullable(clazz.cast(this.jsonPath()));
            }
            case "recordIndex": {
                return Optional.ofNullable(clazz.cast(this.recordIndex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jsonPath", JSON_PATH_FIELD);
        map.put("recordIndex", RECORD_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Record, T> g) {
        return obj -> g.apply((Record)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jsonPath;
        private Long recordIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            this.jsonPath(model.jsonPath);
            this.recordIndex(model.recordIndex);
        }

        public final String getJsonPath() {
            return this.jsonPath;
        }

        public final void setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
        }

        @Override
        public final Builder jsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        public final Long getRecordIndex() {
            return this.recordIndex;
        }

        public final void setRecordIndex(Long recordIndex) {
            this.recordIndex = recordIndex;
        }

        @Override
        public final Builder recordIndex(Long recordIndex) {
            this.recordIndex = recordIndex;
            return this;
        }

        public Record build() {
            return new Record(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Record> {
        public Builder jsonPath(String var1);

        public Builder recordIndex(Long var1);
    }
}

