/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessControlList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessControlList> {
    private static final SdkField<Boolean> ALLOWS_PUBLIC_READ_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowsPublicReadAccess").getter(AccessControlList.getter(AccessControlList::allowsPublicReadAccess)).setter(AccessControlList.setter(Builder::allowsPublicReadAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowsPublicReadAccess").build()}).build();
    private static final SdkField<Boolean> ALLOWS_PUBLIC_WRITE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowsPublicWriteAccess").getter(AccessControlList.getter(AccessControlList::allowsPublicWriteAccess)).setter(AccessControlList.setter(Builder::allowsPublicWriteAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowsPublicWriteAccess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWS_PUBLIC_READ_ACCESS_FIELD, ALLOWS_PUBLIC_WRITE_ACCESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessControlList.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean allowsPublicReadAccess;
    private final Boolean allowsPublicWriteAccess;

    private AccessControlList(BuilderImpl builder) {
        this.allowsPublicReadAccess = builder.allowsPublicReadAccess;
        this.allowsPublicWriteAccess = builder.allowsPublicWriteAccess;
    }

    public final Boolean allowsPublicReadAccess() {
        return this.allowsPublicReadAccess;
    }

    public final Boolean allowsPublicWriteAccess() {
        return this.allowsPublicWriteAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowsPublicReadAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowsPublicWriteAccess());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControlList)) {
            return false;
        }
        AccessControlList other = (AccessControlList)obj;
        return Objects.equals(this.allowsPublicReadAccess(), other.allowsPublicReadAccess()) && Objects.equals(this.allowsPublicWriteAccess(), other.allowsPublicWriteAccess());
    }

    public final String toString() {
        return ToString.builder((String)"AccessControlList").add("AllowsPublicReadAccess", (Object)this.allowsPublicReadAccess()).add("AllowsPublicWriteAccess", (Object)this.allowsPublicWriteAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowsPublicReadAccess": {
                return Optional.ofNullable(clazz.cast(this.allowsPublicReadAccess()));
            }
            case "allowsPublicWriteAccess": {
                return Optional.ofNullable(clazz.cast(this.allowsPublicWriteAccess()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Boolean>> map = new HashMap<String, SdkField<Boolean>>();
        map.put("allowsPublicReadAccess", ALLOWS_PUBLIC_READ_ACCESS_FIELD);
        map.put("allowsPublicWriteAccess", ALLOWS_PUBLIC_WRITE_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessControlList, T> g) {
        return obj -> g.apply((AccessControlList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allowsPublicReadAccess;
        private Boolean allowsPublicWriteAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessControlList model) {
            this.allowsPublicReadAccess(model.allowsPublicReadAccess);
            this.allowsPublicWriteAccess(model.allowsPublicWriteAccess);
        }

        public final Boolean getAllowsPublicReadAccess() {
            return this.allowsPublicReadAccess;
        }

        public final void setAllowsPublicReadAccess(Boolean allowsPublicReadAccess) {
            this.allowsPublicReadAccess = allowsPublicReadAccess;
        }

        @Override
        public final Builder allowsPublicReadAccess(Boolean allowsPublicReadAccess) {
            this.allowsPublicReadAccess = allowsPublicReadAccess;
            return this;
        }

        public final Boolean getAllowsPublicWriteAccess() {
            return this.allowsPublicWriteAccess;
        }

        public final void setAllowsPublicWriteAccess(Boolean allowsPublicWriteAccess) {
            this.allowsPublicWriteAccess = allowsPublicWriteAccess;
        }

        @Override
        public final Builder allowsPublicWriteAccess(Boolean allowsPublicWriteAccess) {
            this.allowsPublicWriteAccess = allowsPublicWriteAccess;
            return this;
        }

        public AccessControlList build() {
            return new AccessControlList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessControlList> {
        public Builder allowsPublicReadAccess(Boolean var1);

        public Builder allowsPublicWriteAccess(Boolean var1);
    }
}

