/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionContextAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionContextAttributes> {
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(SessionContextAttributes.getter(SessionContextAttributes::creationDate)).setter(SessionContextAttributes.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> MFA_AUTHENTICATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("mfaAuthenticated").getter(SessionContextAttributes.getter(SessionContextAttributes::mfaAuthenticated)).setter(SessionContextAttributes.setter(Builder::mfaAuthenticated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mfaAuthenticated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD, MFA_AUTHENTICATED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SessionContextAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant creationDate;
    private final Boolean mfaAuthenticated;

    private SessionContextAttributes(BuilderImpl builder) {
        this.creationDate = builder.creationDate;
        this.mfaAuthenticated = builder.mfaAuthenticated;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Boolean mfaAuthenticated() {
        return this.mfaAuthenticated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaAuthenticated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionContextAttributes)) {
            return false;
        }
        SessionContextAttributes other = (SessionContextAttributes)obj;
        return Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.mfaAuthenticated(), other.mfaAuthenticated());
    }

    public final String toString() {
        return ToString.builder((String)"SessionContextAttributes").add("CreationDate", (Object)this.creationDate()).add("MfaAuthenticated", (Object)this.mfaAuthenticated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "mfaAuthenticated": {
                return Optional.ofNullable(clazz.cast(this.mfaAuthenticated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("mfaAuthenticated", MFA_AUTHENTICATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionContextAttributes, T> g) {
        return obj -> g.apply((SessionContextAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationDate;
        private Boolean mfaAuthenticated;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionContextAttributes model) {
            this.creationDate(model.creationDate);
            this.mfaAuthenticated(model.mfaAuthenticated);
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Boolean getMfaAuthenticated() {
            return this.mfaAuthenticated;
        }

        public final void setMfaAuthenticated(Boolean mfaAuthenticated) {
            this.mfaAuthenticated = mfaAuthenticated;
        }

        @Override
        public final Builder mfaAuthenticated(Boolean mfaAuthenticated) {
            this.mfaAuthenticated = mfaAuthenticated;
            return this;
        }

        public SessionContextAttributes build() {
            return new SessionContextAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionContextAttributes> {
        public Builder creationDate(Instant var1);

        public Builder mfaAuthenticated(Boolean var1);
    }
}

