/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationDetails> {
    private static final SdkField<Boolean> REPLICATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("replicated").getter(ReplicationDetails.getter(ReplicationDetails::replicated)).setter(ReplicationDetails.setter(Builder::replicated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicated").build()}).build();
    private static final SdkField<Boolean> REPLICATED_EXTERNALLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("replicatedExternally").getter(ReplicationDetails.getter(ReplicationDetails::replicatedExternally)).setter(ReplicationDetails.setter(Builder::replicatedExternally)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatedExternally").build()}).build();
    private static final SdkField<List<String>> REPLICATION_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicationAccounts").getter(ReplicationDetails.getter(ReplicationDetails::replicationAccounts)).setter(ReplicationDetails.setter(Builder::replicationAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATED_FIELD, REPLICATED_EXTERNALLY_FIELD, REPLICATION_ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("replicated", REPLICATED_FIELD);
            this.put("replicatedExternally", REPLICATED_EXTERNALLY_FIELD);
            this.put("replicationAccounts", REPLICATION_ACCOUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean replicated;
    private final Boolean replicatedExternally;
    private final List<String> replicationAccounts;

    private ReplicationDetails(BuilderImpl builder) {
        this.replicated = builder.replicated;
        this.replicatedExternally = builder.replicatedExternally;
        this.replicationAccounts = builder.replicationAccounts;
    }

    public final Boolean replicated() {
        return this.replicated;
    }

    public final Boolean replicatedExternally() {
        return this.replicatedExternally;
    }

    public final boolean hasReplicationAccounts() {
        return this.replicationAccounts != null && !(this.replicationAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> replicationAccounts() {
        return this.replicationAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicated());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatedExternally());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationAccounts() ? this.replicationAccounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationDetails)) {
            return false;
        }
        ReplicationDetails other = (ReplicationDetails)obj;
        return Objects.equals(this.replicated(), other.replicated()) && Objects.equals(this.replicatedExternally(), other.replicatedExternally()) && this.hasReplicationAccounts() == other.hasReplicationAccounts() && Objects.equals(this.replicationAccounts(), other.replicationAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationDetails").add("Replicated", (Object)this.replicated()).add("ReplicatedExternally", (Object)this.replicatedExternally()).add("ReplicationAccounts", this.hasReplicationAccounts() ? this.replicationAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replicated": {
                return Optional.ofNullable(clazz.cast(this.replicated()));
            }
            case "replicatedExternally": {
                return Optional.ofNullable(clazz.cast(this.replicatedExternally()));
            }
            case "replicationAccounts": {
                return Optional.ofNullable(clazz.cast(this.replicationAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationDetails, T> g) {
        return obj -> g.apply((ReplicationDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean replicated;
        private Boolean replicatedExternally;
        private List<String> replicationAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationDetails model) {
            this.replicated(model.replicated);
            this.replicatedExternally(model.replicatedExternally);
            this.replicationAccounts(model.replicationAccounts);
        }

        public final Boolean getReplicated() {
            return this.replicated;
        }

        public final void setReplicated(Boolean replicated) {
            this.replicated = replicated;
        }

        @Override
        public final Builder replicated(Boolean replicated) {
            this.replicated = replicated;
            return this;
        }

        public final Boolean getReplicatedExternally() {
            return this.replicatedExternally;
        }

        public final void setReplicatedExternally(Boolean replicatedExternally) {
            this.replicatedExternally = replicatedExternally;
        }

        @Override
        public final Builder replicatedExternally(Boolean replicatedExternally) {
            this.replicatedExternally = replicatedExternally;
            return this;
        }

        public final Collection<String> getReplicationAccounts() {
            if (this.replicationAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationAccounts;
        }

        public final void setReplicationAccounts(Collection<String> replicationAccounts) {
            this.replicationAccounts = ___listOf__stringCopier.copy(replicationAccounts);
        }

        @Override
        public final Builder replicationAccounts(Collection<String> replicationAccounts) {
            this.replicationAccounts = ___listOf__stringCopier.copy(replicationAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationAccounts(String ... replicationAccounts) {
            this.replicationAccounts(Arrays.asList(replicationAccounts));
            return this;
        }

        public ReplicationDetails build() {
            return new ReplicationDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationDetails> {
        public Builder replicated(Boolean var1);

        public Builder replicatedExternally(Boolean var1);

        public Builder replicationAccounts(Collection<String> var1);

        public Builder replicationAccounts(String ... var1);
    }
}

