/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccount;
import software.amazon.awssdk.services.macie2.model.ListAutomatedDiscoveryAccountsRequest;
import software.amazon.awssdk.services.macie2.model.ListAutomatedDiscoveryAccountsResponse;

public class ListAutomatedDiscoveryAccountsPublisher
implements SdkPublisher<ListAutomatedDiscoveryAccountsResponse> {
    private final Macie2AsyncClient client;
    private final ListAutomatedDiscoveryAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutomatedDiscoveryAccountsPublisher(Macie2AsyncClient client, ListAutomatedDiscoveryAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutomatedDiscoveryAccountsPublisher(Macie2AsyncClient client, ListAutomatedDiscoveryAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutomatedDiscoveryAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutomatedDiscoveryAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutomatedDiscoveryAccount> items() {
        Function<ListAutomatedDiscoveryAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAutomatedDiscoveryAccountsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAutomatedDiscoveryAccountsResponseFetcher
    implements AsyncPageFetcher<ListAutomatedDiscoveryAccountsResponse> {
        private ListAutomatedDiscoveryAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomatedDiscoveryAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutomatedDiscoveryAccountsResponse> nextPage(ListAutomatedDiscoveryAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListAutomatedDiscoveryAccountsPublisher.this.client.listAutomatedDiscoveryAccounts(ListAutomatedDiscoveryAccountsPublisher.this.firstRequest);
            }
            return ListAutomatedDiscoveryAccountsPublisher.this.client.listAutomatedDiscoveryAccounts((ListAutomatedDiscoveryAccountsRequest)((Object)ListAutomatedDiscoveryAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

