/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AdminStatus {
    ENABLED("ENABLED"),
    DISABLING_IN_PROGRESS("DISABLING_IN_PROGRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AdminStatus> VALUE_MAP;
    private final String value;

    private AdminStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AdminStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AdminStatus> knownValues() {
        EnumSet<AdminStatus> knownValues = EnumSet.allOf(AdminStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AdminStatus.class, AdminStatus::toString);
    }
}

