/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.RetrievalMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrievalConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetrievalConfiguration> {
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(RetrievalConfiguration.getter(RetrievalConfiguration::externalId)).setter(RetrievalConfiguration.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<String> RETRIEVAL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("retrievalMode").getter(RetrievalConfiguration.getter(RetrievalConfiguration::retrievalModeAsString)).setter(RetrievalConfiguration.setter(Builder::retrievalMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalMode").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleName").getter(RetrievalConfiguration.getter(RetrievalConfiguration::roleName)).setter(RetrievalConfiguration.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_ID_FIELD, RETRIEVAL_MODE_FIELD, ROLE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String externalId;
    private final String retrievalMode;
    private final String roleName;

    private RetrievalConfiguration(BuilderImpl builder) {
        this.externalId = builder.externalId;
        this.retrievalMode = builder.retrievalMode;
        this.roleName = builder.roleName;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final RetrievalMode retrievalMode() {
        return RetrievalMode.fromValue(this.retrievalMode);
    }

    public final String retrievalModeAsString() {
        return this.retrievalMode;
    }

    public final String roleName() {
        return this.roleName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalConfiguration)) {
            return false;
        }
        RetrievalConfiguration other = (RetrievalConfiguration)obj;
        return Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.retrievalModeAsString(), other.retrievalModeAsString()) && Objects.equals(this.roleName(), other.roleName());
    }

    public final String toString() {
        return ToString.builder((String)"RetrievalConfiguration").add("ExternalId", (Object)this.externalId()).add("RetrievalMode", (Object)this.retrievalModeAsString()).add("RoleName", (Object)this.roleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "retrievalMode": {
                return Optional.ofNullable(clazz.cast(this.retrievalModeAsString()));
            }
            case "roleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrievalConfiguration, T> g) {
        return obj -> g.apply((RetrievalConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String externalId;
        private String retrievalMode;
        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalConfiguration model) {
            this.externalId(model.externalId);
            this.retrievalMode(model.retrievalMode);
            this.roleName(model.roleName);
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getRetrievalMode() {
            return this.retrievalMode;
        }

        public final void setRetrievalMode(String retrievalMode) {
            this.retrievalMode = retrievalMode;
        }

        @Override
        public final Builder retrievalMode(String retrievalMode) {
            this.retrievalMode = retrievalMode;
            return this;
        }

        @Override
        public final Builder retrievalMode(RetrievalMode retrievalMode) {
            this.retrievalMode(retrievalMode == null ? null : retrievalMode.toString());
            return this;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public RetrievalConfiguration build() {
            return new RetrievalConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetrievalConfiguration> {
        public Builder externalId(String var1);

        public Builder retrievalMode(String var1);

        public Builder retrievalMode(RetrievalMode var1);

        public Builder roleName(String var1);
    }
}

