/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie2.model.JobSummary;
import software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest;
import software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse;

public class ListClassificationJobsIterable
implements SdkIterable<ListClassificationJobsResponse> {
    private final Macie2Client client;
    private final ListClassificationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClassificationJobsIterable(Macie2Client client, ListClassificationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClassificationJobsResponseFetcher();
    }

    public Iterator<ListClassificationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobSummary> items() {
        Function<ListClassificationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClassificationJobsResponseFetcher
    implements SyncPageFetcher<ListClassificationJobsResponse> {
        private ListClassificationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListClassificationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClassificationJobsResponse nextPage(ListClassificationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListClassificationJobsIterable.this.client.listClassificationJobs(ListClassificationJobsIterable.this.firstRequest);
            }
            return ListClassificationJobsIterable.this.client.listClassificationJobs((ListClassificationJobsRequest)((Object)ListClassificationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

