/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersResponse;
import software.amazon.awssdk.services.macie2.model.ManagedDataIdentifierSummary;

public class ListManagedDataIdentifiersPublisher
implements SdkPublisher<ListManagedDataIdentifiersResponse> {
    private final Macie2AsyncClient client;
    private final ListManagedDataIdentifiersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedDataIdentifiersPublisher(Macie2AsyncClient client, ListManagedDataIdentifiersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedDataIdentifiersPublisher(Macie2AsyncClient client, ListManagedDataIdentifiersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedDataIdentifiersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedDataIdentifiersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedDataIdentifierSummary> items() {
        Function<ListManagedDataIdentifiersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedDataIdentifiersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedDataIdentifiersResponseFetcher
    implements AsyncPageFetcher<ListManagedDataIdentifiersResponse> {
        private ListManagedDataIdentifiersResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedDataIdentifiersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedDataIdentifiersResponse> nextPage(ListManagedDataIdentifiersResponse previousPage) {
            if (previousPage == null) {
                return ListManagedDataIdentifiersPublisher.this.client.listManagedDataIdentifiers(ListManagedDataIdentifiersPublisher.this.firstRequest);
            }
            return ListManagedDataIdentifiersPublisher.this.client.listManagedDataIdentifiers((ListManagedDataIdentifiersRequest)((Object)ListManagedDataIdentifiersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

