/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * Specifies why occurrences of sensitive data can't be retrieved for a finding. Possible values are:
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum UnavailabilityReasonCode {
    OBJECT_EXCEEDS_SIZE_QUOTA("OBJECT_EXCEEDS_SIZE_QUOTA"),

    UNSUPPORTED_OBJECT_TYPE("UNSUPPORTED_OBJECT_TYPE"),

    UNSUPPORTED_FINDING_TYPE("UNSUPPORTED_FINDING_TYPE"),

    INVALID_CLASSIFICATION_RESULT("INVALID_CLASSIFICATION_RESULT"),

    OBJECT_UNAVAILABLE("OBJECT_UNAVAILABLE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UnavailabilityReasonCode> VALUE_MAP = EnumUtils.uniqueIndex(UnavailabilityReasonCode.class,
            UnavailabilityReasonCode::toString);

    private final String value;

    private UnavailabilityReasonCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return UnavailabilityReasonCode corresponding to the value
     */
    public static UnavailabilityReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link UnavailabilityReasonCode}s
     */
    public static Set<UnavailabilityReasonCode> knownValues() {
        Set<UnavailabilityReasonCode> knownValues = EnumSet.allOf(UnavailabilityReasonCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
