/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceProfileArtifactsResponse extends Macie2Response implements
        ToCopyableBuilder<ListResourceProfileArtifactsResponse.Builder, ListResourceProfileArtifactsResponse> {
    private static final SdkField<List<ResourceProfileArtifact>> ARTIFACTS_FIELD = SdkField
            .<List<ResourceProfileArtifact>> builder(MarshallingType.LIST)
            .memberName("artifacts")
            .getter(getter(ListResourceProfileArtifactsResponse::artifacts))
            .setter(setter(Builder::artifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceProfileArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceProfileArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListResourceProfileArtifactsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ResourceProfileArtifact> artifacts;

    private final String nextToken;

    private ListResourceProfileArtifactsResponse(BuilderImpl builder) {
        super(builder);
        this.artifacts = builder.artifacts;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Artifacts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasArtifacts() {
        return artifacts != null && !(artifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each of 1-100 S3 objects that Amazon Macie selected for analysis.
     * </p>
     * <p>
     * If Macie has analyzed more than 100 objects in the bucket, Macie populates the array based on the value for the
     * ResourceProfileArtifact.sensitive field for an object: true (sensitive), followed by false (not sensitive). Macie
     * then populates any remaining items in the array with information about objects where the value for the
     * ResourceProfileArtifact.classificationResultStatus field is SKIPPED.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArtifacts} method.
     * </p>
     * 
     * @return An array of objects, one for each of 1-100 S3 objects that Amazon Macie selected for analysis.</p>
     *         <p>
     *         If Macie has analyzed more than 100 objects in the bucket, Macie populates the array based on the value
     *         for the ResourceProfileArtifact.sensitive field for an object: true (sensitive), followed by false (not
     *         sensitive). Macie then populates any remaining items in the array with information about objects where
     *         the value for the ResourceProfileArtifact.classificationResultStatus field is SKIPPED.
     */
    public final List<ResourceProfileArtifact> artifacts() {
        return artifacts;
    }

    /**
     * <p>
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is
     * null if there are no additional pages.
     * </p>
     * 
     * @return The string to use in a subsequent request to get the next page of results in a paginated response. This
     *         value is null if there are no additional pages.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasArtifacts() ? artifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceProfileArtifactsResponse)) {
            return false;
        }
        ListResourceProfileArtifactsResponse other = (ListResourceProfileArtifactsResponse) obj;
        return hasArtifacts() == other.hasArtifacts() && Objects.equals(artifacts(), other.artifacts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceProfileArtifactsResponse").add("Artifacts", hasArtifacts() ? artifacts() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "artifacts":
            return Optional.ofNullable(clazz.cast(artifacts()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceProfileArtifactsResponse, T> g) {
        return obj -> g.apply((ListResourceProfileArtifactsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceProfileArtifactsResponse> {
        /**
         * <p>
         * An array of objects, one for each of 1-100 S3 objects that Amazon Macie selected for analysis.
         * </p>
         * <p>
         * If Macie has analyzed more than 100 objects in the bucket, Macie populates the array based on the value for
         * the ResourceProfileArtifact.sensitive field for an object: true (sensitive), followed by false (not
         * sensitive). Macie then populates any remaining items in the array with information about objects where the
         * value for the ResourceProfileArtifact.classificationResultStatus field is SKIPPED.
         * </p>
         * 
         * @param artifacts
         *        An array of objects, one for each of 1-100 S3 objects that Amazon Macie selected for analysis.</p>
         *        <p>
         *        If Macie has analyzed more than 100 objects in the bucket, Macie populates the array based on the
         *        value for the ResourceProfileArtifact.sensitive field for an object: true (sensitive), followed by
         *        false (not sensitive). Macie then populates any remaining items in the array with information about
         *        objects where the value for the ResourceProfileArtifact.classificationResultStatus field is SKIPPED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifacts(Collection<ResourceProfileArtifact> artifacts);

        /**
         * <p>
         * An array of objects, one for each of 1-100 S3 objects that Amazon Macie selected for analysis.
         * </p>
         * <p>
         * If Macie has analyzed more than 100 objects in the bucket, Macie populates the array based on the value for
         * the ResourceProfileArtifact.sensitive field for an object: true (sensitive), followed by false (not
         * sensitive). Macie then populates any remaining items in the array with information about objects where the
         * value for the ResourceProfileArtifact.classificationResultStatus field is SKIPPED.
         * </p>
         * 
         * @param artifacts
         *        An array of objects, one for each of 1-100 S3 objects that Amazon Macie selected for analysis.</p>
         *        <p>
         *        If Macie has analyzed more than 100 objects in the bucket, Macie populates the array based on the
         *        value for the ResourceProfileArtifact.sensitive field for an object: true (sensitive), followed by
         *        false (not sensitive). Macie then populates any remaining items in the array with information about
         *        objects where the value for the ResourceProfileArtifact.classificationResultStatus field is SKIPPED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifacts(ResourceProfileArtifact... artifacts);

        /**
         * <p>
         * An array of objects, one for each of 1-100 S3 objects that Amazon Macie selected for analysis.
         * </p>
         * <p>
         * If Macie has analyzed more than 100 objects in the bucket, Macie populates the array based on the value for
         * the ResourceProfileArtifact.sensitive field for an object: true (sensitive), followed by false (not
         * sensitive). Macie then populates any remaining items in the array with information about objects where the
         * value for the ResourceProfileArtifact.classificationResultStatus field is SKIPPED.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.ResourceProfileArtifact.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.macie2.model.ResourceProfileArtifact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.ResourceProfileArtifact.Builder#build()} is called
         * immediately and its result is passed to {@link #artifacts(List<ResourceProfileArtifact>)}.
         * 
         * @param artifacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.ResourceProfileArtifact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifacts(java.util.Collection<ResourceProfileArtifact>)
         */
        Builder artifacts(Consumer<ResourceProfileArtifact.Builder>... artifacts);

        /**
         * <p>
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value
         * is null if there are no additional pages.
         * </p>
         * 
         * @param nextToken
         *        The string to use in a subsequent request to get the next page of results in a paginated response.
         *        This value is null if there are no additional pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private List<ResourceProfileArtifact> artifacts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceProfileArtifactsResponse model) {
            super(model);
            artifacts(model.artifacts);
            nextToken(model.nextToken);
        }

        public final List<ResourceProfileArtifact.Builder> getArtifacts() {
            List<ResourceProfileArtifact.Builder> result = ___listOfResourceProfileArtifactCopier.copyToBuilder(this.artifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArtifacts(Collection<ResourceProfileArtifact.BuilderImpl> artifacts) {
            this.artifacts = ___listOfResourceProfileArtifactCopier.copyFromBuilder(artifacts);
        }

        @Override
        public final Builder artifacts(Collection<ResourceProfileArtifact> artifacts) {
            this.artifacts = ___listOfResourceProfileArtifactCopier.copy(artifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(ResourceProfileArtifact... artifacts) {
            artifacts(Arrays.asList(artifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(Consumer<ResourceProfileArtifact.Builder>... artifacts) {
            artifacts(Stream.of(artifacts).map(c -> ResourceProfileArtifact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceProfileArtifactsResponse build() {
            return new ListResourceProfileArtifactsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
