/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the permissions settings that determine whether an S3 bucket is publicly accessible.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketPublicAccess implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketPublicAccess.Builder, BucketPublicAccess> {
    private static final SdkField<String> EFFECTIVE_PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("effectivePermission").getter(getter(BucketPublicAccess::effectivePermissionAsString))
            .setter(setter(Builder::effectivePermission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectivePermission").build())
            .build();

    private static final SdkField<BucketPermissionConfiguration> PERMISSION_CONFIGURATION_FIELD = SdkField
            .<BucketPermissionConfiguration> builder(MarshallingType.SDK_POJO).memberName("permissionConfiguration")
            .getter(getter(BucketPublicAccess::permissionConfiguration)).setter(setter(Builder::permissionConfiguration))
            .constructor(BucketPermissionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECTIVE_PERMISSION_FIELD,
            PERMISSION_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String effectivePermission;

    private final BucketPermissionConfiguration permissionConfiguration;

    private BucketPublicAccess(BuilderImpl builder) {
        this.effectivePermission = builder.effectivePermission;
        this.permissionConfiguration = builder.permissionConfiguration;
    }

    /**
     * <p>
     * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to
     * the bucket. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * NOT_PUBLIC - The bucket isn't publicly accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * PUBLIC - The bucket is publicly accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #effectivePermission} will return {@link EffectivePermission#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #effectivePermissionAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies whether the bucket is publicly accessible due to the combination of permissions settings that
     *         apply to the bucket. Possible values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         NOT_PUBLIC - The bucket isn't publicly accessible.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PUBLIC - The bucket is publicly accessible.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.
     *         </p>
     *         </li>
     *         </ul>
     * @see EffectivePermission
     */
    public final EffectivePermission effectivePermission() {
        return EffectivePermission.fromValue(effectivePermission);
    }

    /**
     * <p>
     * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to
     * the bucket. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * NOT_PUBLIC - The bucket isn't publicly accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * PUBLIC - The bucket is publicly accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #effectivePermission} will return {@link EffectivePermission#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #effectivePermissionAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies whether the bucket is publicly accessible due to the combination of permissions settings that
     *         apply to the bucket. Possible values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         NOT_PUBLIC - The bucket isn't publicly accessible.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PUBLIC - The bucket is publicly accessible.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.
     *         </p>
     *         </li>
     *         </ul>
     * @see EffectivePermission
     */
    public final String effectivePermissionAsString() {
        return effectivePermission;
    }

    /**
     * <p>
     * The account-level and bucket-level permissions settings for the bucket.
     * </p>
     * 
     * @return The account-level and bucket-level permissions settings for the bucket.
     */
    public final BucketPermissionConfiguration permissionConfiguration() {
        return permissionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(effectivePermissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(permissionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketPublicAccess)) {
            return false;
        }
        BucketPublicAccess other = (BucketPublicAccess) obj;
        return Objects.equals(effectivePermissionAsString(), other.effectivePermissionAsString())
                && Objects.equals(permissionConfiguration(), other.permissionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketPublicAccess").add("EffectivePermission", effectivePermissionAsString())
                .add("PermissionConfiguration", permissionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "effectivePermission":
            return Optional.ofNullable(clazz.cast(effectivePermissionAsString()));
        case "permissionConfiguration":
            return Optional.ofNullable(clazz.cast(permissionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketPublicAccess, T> g) {
        return obj -> g.apply((BucketPublicAccess) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketPublicAccess> {
        /**
         * <p>
         * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply
         * to the bucket. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * NOT_PUBLIC - The bucket isn't publicly accessible.
         * </p>
         * </li>
         * <li>
         * <p>
         * PUBLIC - The bucket is publicly accessible.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.
         * </p>
         * </li>
         * </ul>
         * 
         * @param effectivePermission
         *        <p>
         *        Specifies whether the bucket is publicly accessible due to the combination of permissions settings
         *        that apply to the bucket. Possible values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        NOT_PUBLIC - The bucket isn't publicly accessible.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PUBLIC - The bucket is publicly accessible.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.
         *        </p>
         *        </li>
         *        </ul>
         * @see EffectivePermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EffectivePermission
         */
        Builder effectivePermission(String effectivePermission);

        /**
         * <p>
         * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply
         * to the bucket. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * NOT_PUBLIC - The bucket isn't publicly accessible.
         * </p>
         * </li>
         * <li>
         * <p>
         * PUBLIC - The bucket is publicly accessible.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.
         * </p>
         * </li>
         * </ul>
         * 
         * @param effectivePermission
         *        <p>
         *        Specifies whether the bucket is publicly accessible due to the combination of permissions settings
         *        that apply to the bucket. Possible values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        NOT_PUBLIC - The bucket isn't publicly accessible.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PUBLIC - The bucket is publicly accessible.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.
         *        </p>
         *        </li>
         *        </ul>
         * @see EffectivePermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EffectivePermission
         */
        Builder effectivePermission(EffectivePermission effectivePermission);

        /**
         * <p>
         * The account-level and bucket-level permissions settings for the bucket.
         * </p>
         * 
         * @param permissionConfiguration
         *        The account-level and bucket-level permissions settings for the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionConfiguration(BucketPermissionConfiguration permissionConfiguration);

        /**
         * <p>
         * The account-level and bucket-level permissions settings for the bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link BucketPermissionConfiguration.Builder}
         * avoiding the need to create one manually via {@link BucketPermissionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BucketPermissionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #permissionConfiguration(BucketPermissionConfiguration)}.
         * 
         * @param permissionConfiguration
         *        a consumer that will call methods on {@link BucketPermissionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionConfiguration(BucketPermissionConfiguration)
         */
        default Builder permissionConfiguration(Consumer<BucketPermissionConfiguration.Builder> permissionConfiguration) {
            return permissionConfiguration(BucketPermissionConfiguration.builder().applyMutation(permissionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String effectivePermission;

        private BucketPermissionConfiguration permissionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketPublicAccess model) {
            effectivePermission(model.effectivePermission);
            permissionConfiguration(model.permissionConfiguration);
        }

        public final String getEffectivePermission() {
            return effectivePermission;
        }

        public final void setEffectivePermission(String effectivePermission) {
            this.effectivePermission = effectivePermission;
        }

        @Override
        public final Builder effectivePermission(String effectivePermission) {
            this.effectivePermission = effectivePermission;
            return this;
        }

        @Override
        public final Builder effectivePermission(EffectivePermission effectivePermission) {
            this.effectivePermission(effectivePermission == null ? null : effectivePermission.toString());
            return this;
        }

        public final BucketPermissionConfiguration.Builder getPermissionConfiguration() {
            return permissionConfiguration != null ? permissionConfiguration.toBuilder() : null;
        }

        public final void setPermissionConfiguration(BucketPermissionConfiguration.BuilderImpl permissionConfiguration) {
            this.permissionConfiguration = permissionConfiguration != null ? permissionConfiguration.build() : null;
        }

        @Override
        public final Builder permissionConfiguration(BucketPermissionConfiguration permissionConfiguration) {
            this.permissionConfiguration = permissionConfiguration;
            return this;
        }

        @Override
        public BucketPublicAccess build() {
            return new BucketPublicAccess(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
