/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsageStatisticsResponse extends Macie2Response implements
        ToCopyableBuilder<GetUsageStatisticsResponse.Builder, GetUsageStatisticsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetUsageStatisticsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<UsageRecord>> RECORDS_FIELD = SdkField
            .<List<UsageRecord>> builder(MarshallingType.LIST)
            .memberName("records")
            .getter(getter(GetUsageStatisticsResponse::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TIME_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeRange").getter(getter(GetUsageStatisticsResponse::timeRangeAsString))
            .setter(setter(Builder::timeRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RECORDS_FIELD, TIME_RANGE_FIELD));

    private final String nextToken;

    private final List<UsageRecord> records;

    private final String timeRange;

    private GetUsageStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.records = builder.records;
        this.timeRange = builder.timeRange;
    }

    /**
     * <p>
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is
     * null if there are no additional pages.
     * </p>
     * 
     * @return The string to use in a subsequent request to get the next page of results in a paginated response. This
     *         value is null if there are no additional pages.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that contains the results of the query. Each object contains the data for an account that
     * matches the filter criteria specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return An array of objects that contains the results of the query. Each object contains the data for an account
     *         that matches the filter criteria specified in the request.
     */
    public final List<UsageRecord> records() {
        return records;
    }

    /**
     * <p>
     * The inclusive time period that the usage data applies to. Possible values are: MONTH_TO_DATE, for the current
     * calendar month to date; and, PAST_30_DAYS, for the preceding 30 days.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeRange} will
     * return {@link TimeRange#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeRangeAsString}.
     * </p>
     * 
     * @return The inclusive time period that the usage data applies to. Possible values are: MONTH_TO_DATE, for the
     *         current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days.
     * @see TimeRange
     */
    public final TimeRange timeRange() {
        return TimeRange.fromValue(timeRange);
    }

    /**
     * <p>
     * The inclusive time period that the usage data applies to. Possible values are: MONTH_TO_DATE, for the current
     * calendar month to date; and, PAST_30_DAYS, for the preceding 30 days.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeRange} will
     * return {@link TimeRange#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeRangeAsString}.
     * </p>
     * 
     * @return The inclusive time period that the usage data applies to. Possible values are: MONTH_TO_DATE, for the
     *         current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days.
     * @see TimeRange
     */
    public final String timeRangeAsString() {
        return timeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeRangeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageStatisticsResponse)) {
            return false;
        }
        GetUsageStatisticsResponse other = (GetUsageStatisticsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasRecords() == other.hasRecords()
                && Objects.equals(records(), other.records()) && Objects.equals(timeRangeAsString(), other.timeRangeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUsageStatisticsResponse").add("NextToken", nextToken())
                .add("Records", hasRecords() ? records() : null).add("TimeRange", timeRangeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "records":
            return Optional.ofNullable(clazz.cast(records()));
        case "timeRange":
            return Optional.ofNullable(clazz.cast(timeRangeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUsageStatisticsResponse, T> g) {
        return obj -> g.apply((GetUsageStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetUsageStatisticsResponse> {
        /**
         * <p>
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value
         * is null if there are no additional pages.
         * </p>
         * 
         * @param nextToken
         *        The string to use in a subsequent request to get the next page of results in a paginated response.
         *        This value is null if there are no additional pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of objects that contains the results of the query. Each object contains the data for an account that
         * matches the filter criteria specified in the request.
         * </p>
         * 
         * @param records
         *        An array of objects that contains the results of the query. Each object contains the data for an
         *        account that matches the filter criteria specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<UsageRecord> records);

        /**
         * <p>
         * An array of objects that contains the results of the query. Each object contains the data for an account that
         * matches the filter criteria specified in the request.
         * </p>
         * 
         * @param records
         *        An array of objects that contains the results of the query. Each object contains the data for an
         *        account that matches the filter criteria specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(UsageRecord... records);

        /**
         * <p>
         * An array of objects that contains the results of the query. Each object contains the data for an account that
         * matches the filter criteria specified in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.UsageRecord.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.macie2.model.UsageRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.UsageRecord.Builder#build()} is called immediately and
         * its result is passed to {@link #records(List<UsageRecord>)}.
         * 
         * @param records
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.UsageRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(java.util.Collection<UsageRecord>)
         */
        Builder records(Consumer<UsageRecord.Builder>... records);

        /**
         * <p>
         * The inclusive time period that the usage data applies to. Possible values are: MONTH_TO_DATE, for the current
         * calendar month to date; and, PAST_30_DAYS, for the preceding 30 days.
         * </p>
         * 
         * @param timeRange
         *        The inclusive time period that the usage data applies to. Possible values are: MONTH_TO_DATE, for the
         *        current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days.
         * @see TimeRange
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeRange
         */
        Builder timeRange(String timeRange);

        /**
         * <p>
         * The inclusive time period that the usage data applies to. Possible values are: MONTH_TO_DATE, for the current
         * calendar month to date; and, PAST_30_DAYS, for the preceding 30 days.
         * </p>
         * 
         * @param timeRange
         *        The inclusive time period that the usage data applies to. Possible values are: MONTH_TO_DATE, for the
         *        current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days.
         * @see TimeRange
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeRange
         */
        Builder timeRange(TimeRange timeRange);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<UsageRecord> records = DefaultSdkAutoConstructList.getInstance();

        private String timeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageStatisticsResponse model) {
            super(model);
            nextToken(model.nextToken);
            records(model.records);
            timeRange(model.timeRange);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<UsageRecord.Builder> getRecords() {
            List<UsageRecord.Builder> result = ___listOfUsageRecordCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<UsageRecord.BuilderImpl> records) {
            this.records = ___listOfUsageRecordCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<UsageRecord> records) {
            this.records = ___listOfUsageRecordCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(UsageRecord... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<UsageRecord.Builder>... records) {
            records(Stream.of(records).map(c -> UsageRecord.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTimeRange() {
            return timeRange;
        }

        public final void setTimeRange(String timeRange) {
            this.timeRange = timeRange;
        }

        @Override
        public final Builder timeRange(String timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public final Builder timeRange(TimeRange timeRange) {
            this.timeRange(timeRange == null ? null : timeRange.toString());
            return this;
        }

        @Override
        public GetUsageStatisticsResponse build() {
            return new GetUsageStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
