/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAllowListResponse extends Macie2Response implements
        ToCopyableBuilder<GetAllowListResponse.Builder, GetAllowListResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetAllowListResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetAllowListResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<AllowListCriteria> CRITERIA_FIELD = SdkField
            .<AllowListCriteria> builder(MarshallingType.SDK_POJO).memberName("criteria")
            .getter(getter(GetAllowListResponse::criteria)).setter(setter(Builder::criteria))
            .constructor(AllowListCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criteria").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetAllowListResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetAllowListResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetAllowListResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<AllowListStatus> STATUS_FIELD = SdkField.<AllowListStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(GetAllowListResponse::status)).setter(setter(Builder::status))
            .constructor(AllowListStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetAllowListResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetAllowListResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            CRITERIA_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, STATUS_FIELD, TAGS_FIELD, UPDATED_AT_FIELD));

    private final String arn;

    private final Instant createdAt;

    private final AllowListCriteria criteria;

    private final String description;

    private final String id;

    private final String name;

    private final AllowListStatus status;

    private final Map<String, String> tags;

    private final Instant updatedAt;

    private GetAllowListResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.criteria = builder.criteria;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the allow list.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the allow list.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the allow list was created in Amazon Macie.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the allow list was created in Amazon Macie.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The criteria that specify the text or text pattern to ignore. The criteria can be the location and name of an S3
     * object that lists specific text to ignore (s3WordsList), or a regular expression (regex) that defines a text
     * pattern to ignore.
     * </p>
     * 
     * @return The criteria that specify the text or text pattern to ignore. The criteria can be the location and name
     *         of an S3 object that lists specific text to ignore (s3WordsList), or a regular expression (regex) that
     *         defines a text pattern to ignore.
     */
    public final AllowListCriteria criteria() {
        return criteria;
    }

    /**
     * <p>
     * The custom description of the allow list.
     * </p>
     * 
     * @return The custom description of the allow list.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier for the allow list.
     * </p>
     * 
     * @return The unique identifier for the allow list.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The custom name of the allow list.
     * </p>
     * 
     * @return The custom name of the allow list.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the allow list, which indicates whether Amazon Macie can access and use the list's
     * criteria.
     * </p>
     * 
     * @return The current status of the allow list, which indicates whether Amazon Macie can access and use the list's
     *         criteria.
     */
    public final AllowListStatus status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that specifies which tags (keys and values) are associated with the allow list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of key-value pairs that specifies which tags (keys and values) are associated with the allow list.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the allow list's settings were most recently changed
     * in Amazon Macie.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the allow list's settings were most recently
     *         changed in Amazon Macie.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(criteria());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAllowListResponse)) {
            return false;
        }
        GetAllowListResponse other = (GetAllowListResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(criteria(), other.criteria()) && Objects.equals(description(), other.description())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(status(), other.status()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAllowListResponse").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Criteria", criteria()).add("Description", description()).add("Id", id()).add("Name", name())
                .add("Status", status()).add("Tags", hasTags() ? tags() : null).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "criteria":
            return Optional.ofNullable(clazz.cast(criteria()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAllowListResponse, T> g) {
        return obj -> g.apply((GetAllowListResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetAllowListResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the allow list.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the allow list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the allow list was created in Amazon Macie.
         * </p>
         * 
         * @param createdAt
         *        The date and time, in UTC and extended ISO 8601 format, when the allow list was created in Amazon
         *        Macie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The criteria that specify the text or text pattern to ignore. The criteria can be the location and name of an
         * S3 object that lists specific text to ignore (s3WordsList), or a regular expression (regex) that defines a
         * text pattern to ignore.
         * </p>
         * 
         * @param criteria
         *        The criteria that specify the text or text pattern to ignore. The criteria can be the location and
         *        name of an S3 object that lists specific text to ignore (s3WordsList), or a regular expression (regex)
         *        that defines a text pattern to ignore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteria(AllowListCriteria criteria);

        /**
         * <p>
         * The criteria that specify the text or text pattern to ignore. The criteria can be the location and name of an
         * S3 object that lists specific text to ignore (s3WordsList), or a regular expression (regex) that defines a
         * text pattern to ignore.
         * </p>
         * This is a convenience method that creates an instance of the {@link AllowListCriteria.Builder} avoiding the
         * need to create one manually via {@link AllowListCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AllowListCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #criteria(AllowListCriteria)}.
         * 
         * @param criteria
         *        a consumer that will call methods on {@link AllowListCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #criteria(AllowListCriteria)
         */
        default Builder criteria(Consumer<AllowListCriteria.Builder> criteria) {
            return criteria(AllowListCriteria.builder().applyMutation(criteria).build());
        }

        /**
         * <p>
         * The custom description of the allow list.
         * </p>
         * 
         * @param description
         *        The custom description of the allow list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier for the allow list.
         * </p>
         * 
         * @param id
         *        The unique identifier for the allow list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The custom name of the allow list.
         * </p>
         * 
         * @param name
         *        The custom name of the allow list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the allow list, which indicates whether Amazon Macie can access and use the list's
         * criteria.
         * </p>
         * 
         * @param status
         *        The current status of the allow list, which indicates whether Amazon Macie can access and use the
         *        list's criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(AllowListStatus status);

        /**
         * <p>
         * The current status of the allow list, which indicates whether Amazon Macie can access and use the list's
         * criteria.
         * </p>
         * This is a convenience method that creates an instance of the {@link AllowListStatus.Builder} avoiding the
         * need to create one manually via {@link AllowListStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AllowListStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(AllowListStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link AllowListStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(AllowListStatus)
         */
        default Builder status(Consumer<AllowListStatus.Builder> status) {
            return status(AllowListStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * A map of key-value pairs that specifies which tags (keys and values) are associated with the allow list.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs that specifies which tags (keys and values) are associated with the allow
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the allow list's settings were most recently
         * changed in Amazon Macie.
         * </p>
         * 
         * @param updatedAt
         *        The date and time, in UTC and extended ISO 8601 format, when the allow list's settings were most
         *        recently changed in Amazon Macie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private AllowListCriteria criteria;

        private String description;

        private String id;

        private String name;

        private AllowListStatus status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAllowListResponse model) {
            super(model);
            arn(model.arn);
            createdAt(model.createdAt);
            criteria(model.criteria);
            description(model.description);
            id(model.id);
            name(model.name);
            status(model.status);
            tags(model.tags);
            updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final AllowListCriteria.Builder getCriteria() {
            return criteria != null ? criteria.toBuilder() : null;
        }

        public final void setCriteria(AllowListCriteria.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public final Builder criteria(AllowListCriteria criteria) {
            this.criteria = criteria;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AllowListStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(AllowListStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(AllowListStatus status) {
            this.status = status;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetAllowListResponse build() {
            return new GetAllowListResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
