/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AllowListStatusCode {
    OK("OK"),
    S3_OBJECT_NOT_FOUND("S3_OBJECT_NOT_FOUND"),
    S3_USER_ACCESS_DENIED("S3_USER_ACCESS_DENIED"),
    S3_OBJECT_ACCESS_DENIED("S3_OBJECT_ACCESS_DENIED"),
    S3_THROTTLED("S3_THROTTLED"),
    S3_OBJECT_OVERSIZE("S3_OBJECT_OVERSIZE"),
    S3_OBJECT_EMPTY("S3_OBJECT_EMPTY"),
    UNKNOWN_ERROR("UNKNOWN_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AllowListStatusCode> VALUE_MAP;
    private final String value;

    private AllowListStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AllowListStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AllowListStatusCode> knownValues() {
        EnumSet<AllowListStatusCode> knownValues = EnumSet.allOf(AllowListStatusCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AllowListStatusCode.class, AllowListStatusCode::toString);
    }
}

