/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsRequest;
import software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsResponse;
import software.amazon.awssdk.services.macie2.model.ResourceProfileArtifact;

public class ListResourceProfileArtifactsIterable
implements SdkIterable<ListResourceProfileArtifactsResponse> {
    private final Macie2Client client;
    private final ListResourceProfileArtifactsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceProfileArtifactsIterable(Macie2Client client, ListResourceProfileArtifactsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResourceProfileArtifactsResponseFetcher();
    }

    public Iterator<ListResourceProfileArtifactsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceProfileArtifact> artifacts() {
        Function<ListResourceProfileArtifactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.artifacts() != null) {
                return response.artifacts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceProfileArtifactsResponseFetcher
    implements SyncPageFetcher<ListResourceProfileArtifactsResponse> {
        private ListResourceProfileArtifactsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceProfileArtifactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceProfileArtifactsResponse nextPage(ListResourceProfileArtifactsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceProfileArtifactsIterable.this.client.listResourceProfileArtifacts(ListResourceProfileArtifactsIterable.this.firstRequest);
            }
            return ListResourceProfileArtifactsIterable.this.client.listResourceProfileArtifacts((ListResourceProfileArtifactsRequest)((Object)ListResourceProfileArtifactsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

