/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.macie2.DefaultMacie2AsyncClient;
import software.amazon.awssdk.services.macie2.DefaultMacie2BaseClientBuilder;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.Macie2AsyncClientBuilder;
import software.amazon.awssdk.services.macie2.Macie2ServiceClientConfiguration;
import software.amazon.awssdk.services.macie2.endpoints.Macie2EndpointProvider;

@SdkInternalApi
final class DefaultMacie2AsyncClientBuilder
extends DefaultMacie2BaseClientBuilder<Macie2AsyncClientBuilder, Macie2AsyncClient>
implements Macie2AsyncClientBuilder {
    DefaultMacie2AsyncClientBuilder() {
    }

    @Override
    public DefaultMacie2AsyncClientBuilder endpointProvider(Macie2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final Macie2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMacie2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        Macie2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMacie2AsyncClient client = new DefaultMacie2AsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private Macie2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return Macie2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

