/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.TimeRange;
import software.amazon.awssdk.services.macie2.model.UsageTotal;
import software.amazon.awssdk.services.macie2.model.___listOfUsageTotalCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUsageTotalsResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, GetUsageTotalsResponse> {
    private static final SdkField<String> TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeRange").getter(GetUsageTotalsResponse.getter(GetUsageTotalsResponse::timeRangeAsString)).setter(GetUsageTotalsResponse.setter(Builder::timeRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeRange").build()}).build();
    private static final SdkField<List<UsageTotal>> USAGE_TOTALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("usageTotals").getter(GetUsageTotalsResponse.getter(GetUsageTotalsResponse::usageTotals)).setter(GetUsageTotalsResponse.setter(Builder::usageTotals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTotals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageTotal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_RANGE_FIELD, USAGE_TOTALS_FIELD));
    private final String timeRange;
    private final List<UsageTotal> usageTotals;

    private GetUsageTotalsResponse(BuilderImpl builder) {
        super(builder);
        this.timeRange = builder.timeRange;
        this.usageTotals = builder.usageTotals;
    }

    public final TimeRange timeRange() {
        return TimeRange.fromValue(this.timeRange);
    }

    public final String timeRangeAsString() {
        return this.timeRange;
    }

    public final boolean hasUsageTotals() {
        return this.usageTotals != null && !(this.usageTotals instanceof SdkAutoConstructList);
    }

    public final List<UsageTotal> usageTotals() {
        return this.usageTotals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsageTotals() ? this.usageTotals() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageTotalsResponse)) {
            return false;
        }
        GetUsageTotalsResponse other = (GetUsageTotalsResponse)((Object)obj);
        return Objects.equals(this.timeRangeAsString(), other.timeRangeAsString()) && this.hasUsageTotals() == other.hasUsageTotals() && Objects.equals(this.usageTotals(), other.usageTotals());
    }

    public final String toString() {
        return ToString.builder((String)"GetUsageTotalsResponse").add("TimeRange", (Object)this.timeRangeAsString()).add("UsageTotals", this.hasUsageTotals() ? this.usageTotals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timeRange": {
                return Optional.ofNullable(clazz.cast(this.timeRangeAsString()));
            }
            case "usageTotals": {
                return Optional.ofNullable(clazz.cast(this.usageTotals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUsageTotalsResponse, T> g) {
        return obj -> g.apply((GetUsageTotalsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private String timeRange;
        private List<UsageTotal> usageTotals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageTotalsResponse model) {
            super(model);
            this.timeRange(model.timeRange);
            this.usageTotals(model.usageTotals);
        }

        public final String getTimeRange() {
            return this.timeRange;
        }

        public final void setTimeRange(String timeRange) {
            this.timeRange = timeRange;
        }

        @Override
        @Transient
        public final Builder timeRange(String timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        @Override
        @Transient
        public final Builder timeRange(TimeRange timeRange) {
            this.timeRange(timeRange == null ? null : timeRange.toString());
            return this;
        }

        public final List<UsageTotal.Builder> getUsageTotals() {
            List<UsageTotal.Builder> result = ___listOfUsageTotalCopier.copyToBuilder(this.usageTotals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsageTotals(Collection<UsageTotal.BuilderImpl> usageTotals) {
            this.usageTotals = ___listOfUsageTotalCopier.copyFromBuilder(usageTotals);
        }

        @Override
        @Transient
        public final Builder usageTotals(Collection<UsageTotal> usageTotals) {
            this.usageTotals = ___listOfUsageTotalCopier.copy(usageTotals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder usageTotals(UsageTotal ... usageTotals) {
            this.usageTotals(Arrays.asList(usageTotals));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder usageTotals(Consumer<UsageTotal.Builder> ... usageTotals) {
            this.usageTotals(Stream.of(usageTotals).map(c -> (UsageTotal)((UsageTotal.Builder)UsageTotal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetUsageTotalsResponse build() {
            return new GetUsageTotalsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUsageTotalsResponse> {
        public Builder timeRange(String var1);

        public Builder timeRange(TimeRange var1);

        public Builder usageTotals(Collection<UsageTotal> var1);

        public Builder usageTotals(UsageTotal ... var1);

        public Builder usageTotals(Consumer<UsageTotal.Builder> ... var1);
    }
}

